/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.city.BuildingStructureProcessor;
import org.betterx.betternether.world.structures.city.StructureCityBuilding;
import org.betterx.betternether.world.structures.city.palette.CityPalette;
import org.betterx.betternether.world.structures.city.palette.Palettes;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class CityPiece
extends CustomPiece {
    private final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
    private final StructureProcessor paletteProcessor;
    private final StructureCityBuilding building;
    private final CityPalette palette;
    private final BlockPos pos;

    public CityPiece(StructureCityBuilding building, BlockPos pos, int id, CityPalette palette) {
        super(NetherStructurePieces.NETHER_CITY_PIECE, id, building.getBoundingBox(pos));
        this.building = building;
        this.pos = pos.immutable();
        this.boundingBox = building.getBoundingBox(pos);
        this.palette = palette;
        this.paletteProcessor = new BuildingStructureProcessor(palette);
    }

    public CityPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(NetherStructurePieces.NETHER_CITY_PIECE, tag);
        this.building = new StructureCityBuilding(tag.getString("building"), tag.getInt("offset")).getRotated(Rotation.values()[tag.getInt("rotation")]);
        this.building.setMirror(Mirror.values()[tag.getInt("mirror")]);
        this.pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos").orElse(BlockPos.ZERO);
        this.boundingBox = this.building.getBoundingBox(this.pos);
        this.palette = Palettes.getPalette(tag.getString("palette"));
        this.paletteProcessor = new BuildingStructureProcessor(this.palette);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        tag.putString("building", this.building.getName());
        tag.putInt("rotation", this.building.getRotation().ordinal());
        tag.putInt("mirror", this.building.getMirror().ordinal());
        tag.putInt("offset", this.building.getYOffset());
        tag.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        tag.putString("palette", this.palette.getName());
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (!this.boundingBox.intersects(blockBox)) {
            return;
        }
        BoundingBox clamped = new BoundingBox(this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ());
        int cminZ = Math.max(clamped.minZ(), blockBox.minZ());
        int cmaxZ = Math.min(clamped.maxZ(), blockBox.maxZ());
        int cminX = Math.max(clamped.minX(), blockBox.minX());
        int cmaxX = Math.min(clamped.maxX(), blockBox.maxX());
        int cminY = Math.max(clamped.minY(), blockBox.minY());
        int cmaxY = Math.min(clamped.maxY(), blockBox.maxY());
        clamped = new BoundingBox(cminX, cminY, cminZ, cmaxX, cmaxY, cmaxZ);
        this.building.placeInChunk((ServerLevelAccessor)world, this.pos, clamped, this.paletteProcessor);
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        for (int x = clamped.minX(); x <= clamped.maxX(); ++x) {
            for (int z = clamped.minZ(); z <= clamped.maxZ(); ++z) {
                int y;
                this.POS.set(x, clamped.minY(), z);
                BlockState state = world.getBlockState((BlockPos)this.POS);
                if (!state.isAir() && state.isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)this.POS)) {
                    for (y = clamped.minY() - 1; y > 4; --y) {
                        this.POS.setY(y);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, state);
                        if (BlocksHelper.isNetherGroundMagma(world.getBlockState(this.POS.below()))) break;
                    }
                }
                this.POS.set(x - clamped.minX(), clamped.minY(), z - clamped.minZ());
                for (y = clamped.minY(); y <= clamped.maxY(); ++y) {
                    this.POS.setY(y);
                    chunk.markPosForPostprocessing((BlockPos)this.POS);
                }
            }
        }
    }
}

