/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class DestructionPiece
extends CustomPiece {
    private final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
    private final BlockPos center;
    private final int radius;
    private final int radSqr;
    private int minY;
    private int maxY;

    public DestructionPiece(BoundingBox bounds, RandomSource random) {
        super(NetherStructurePieces.DESTRUCTION_PIECE, random.nextInt(), bounds);
        this.radius = random.nextInt(5) + 1;
        this.radSqr = this.radius * this.radius;
        this.center = new BlockPos(MHelper.randRange(bounds.minX(), bounds.maxX(), random), MHelper.randRange(bounds.minY(), bounds.maxY(), random), MHelper.randRange(bounds.minZ(), bounds.maxZ(), random));
        this.makeBoundingBox();
    }

    public DestructionPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(NetherStructurePieces.DESTRUCTION_PIECE, tag);
        this.center = NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO);
        this.radius = tag.getInt("radius");
        this.radSqr = this.radius * this.radius;
        this.makeBoundingBox();
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
        tag.putInt("radius", this.radius);
    }

    public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        for (int x = blockBox.maxZ(); x <= blockBox.minZ(); ++x) {
            int px = x - this.center.getX();
            px *= px;
            for (int z = blockBox.minY(); z <= blockBox.maxY(); ++z) {
                int pz = z - this.center.getZ();
                pz *= pz;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int py = y - this.center.getY() << 1;
                    if (px + (py *= py) + pz > this.radSqr + random.nextInt(this.radius)) continue;
                    this.POS.set(x, y, z);
                    if (world.isEmptyBlock((BlockPos)this.POS)) continue;
                    if (random.nextBoolean()) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, CAVE_AIR);
                        continue;
                    }
                    int dist = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)this.POS, this.maxY - 5);
                    if (dist <= 0) continue;
                    BlockState state = world.getBlockState((BlockPos)this.POS);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, CAVE_AIR);
                    this.POS.setY(this.POS.getY() - dist);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, state);
                }
            }
        }
    }

    private void makeBoundingBox() {
        int x1 = this.center.getX() - this.radius;
        int x2 = this.center.getX() + this.radius;
        this.minY = Math.max(22, this.center.getY() - this.radius);
        if (this.minY < 38) {
            this.minY = 38;
        }
        this.maxY = Math.min(96, this.center.getY() + this.radius);
        int z1 = this.center.getZ() - this.radius;
        int z2 = this.center.getZ() + this.radius;
        this.boundingBox = new BoundingBox(x1, this.minY, z1, x2, this.maxY, z2);
    }
}

