/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.plants;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class LegacyStructureAnchorTree
implements IStructure {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);

    @Override
    public void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (this.canGenerate(pos)) {
            this.grow(world, pos, pos.below(BlocksHelper.downRay((LevelAccessor)world, pos, MAX_HEIGHT)), random, MAX_HEIGHT, context);
        }
    }

    private boolean canGenerate(BlockPos pos) {
        return (pos.getX() & 0xF) == 7 && (pos.getZ() & 0xF) == 7;
    }

    private void grow(ServerLevelAccessor level, BlockPos up, BlockPos down, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        int HEIGHT_64 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 10.0f * scale_factor));
        int HEIGHT_45 = (int)(40.0f + MHelper.nextFloat(random, 7.0f * scale_factor));
        int HEIGHT_90 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 15.0f * scale_factor));
        if (up.getY() - down.getY() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((LevelAccessor)level, down, MAX_HEIGHT) + 1;
        for (int i = 0; i < 5; ++i) {
            Block block = level.getBlockState(down.below(pd + i)).getBlock();
            if (block != Blocks.NETHER_BRICKS && block != NetherBlocks.NETHER_BRICK_TILE_LARGE && block != NetherBlocks.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        BlockPos trunkTop = this.lerp(down, up, 0.6);
        BlockPos trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.getY() - trunkBottom.getY()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<BlockPos> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        context.BLOCKS.clear();
        this.buildLine(blocks, 4.0, context);
        count = (up.getY() - down.getY()) / 10 - 1;
        if (count < 3) {
            count = 3;
        }
        this.buildBigCircle(trunkTop, 15, count, 2, random.nextDouble() * Math.PI * 2.0, 3.5, random, context);
        this.buildBigCircle(trunkBottom, -15, count, 2, random.nextDouble() * Math.PI * 2.0, 3.5, random, context);
        int offset = random.nextInt(4);
        int minBuildHeight = level.getMinBuildHeight() + 1;
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)level, up, minBuildHeight, MAX_HEIGHT - 2);
        for (BlockPos bpos : context.BLOCKS) {
            BlockState state;
            if (!blockBox.isInside((Vec3i)bpos) || !BlocksHelper.isNetherGround(state = level.getBlockState(bpos)) && !state.canBeReplaced()) continue;
            boolean blockUp = context.BLOCKS.contains(bpos.above());
            if (blockUp && context.BLOCKS.contains(bpos.below())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().defaultBlockState());
            } else {
                BlocksHelper.setWithUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().defaultBlockState());
            }
            if (bpos.getY() > HEIGHT_45 && bpos.getY() < HEIGHT_90 && (bpos.getY() & 3) == offset && NOISE.eval((double)bpos.getX() * 0.1, (double)bpos.getY() * 0.1, (double)bpos.getZ() * 0.1) > 0.0) {
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.north())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.north(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.south())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.south(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.east())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.east(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.west())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.west(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
            }
            if (bpos.getY() <= HEIGHT_64) continue;
            if (!blockUp && level.getBlockState(bpos.above()).canBeReplaced()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, bpos.above(), NetherBlocks.MOSS_COVER.defaultBlockState());
            }
            if (!(NOISE.eval((double)bpos.getX() * 0.05, (double)bpos.getY() * 0.05, (double)bpos.getZ() * 0.05) > 0.0)) continue;
            Block[] wallPlants = AnchorTreeFeature.wallPlants();
            state = wallPlants[random.nextInt(wallPlants.length)].defaultBlockState();
            BlockPos _pos = bpos.north();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && level.isEmptyBlock(_pos) && _pos.getZ() >= blockBox.minZ()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            _pos = bpos.south();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && level.isEmptyBlock(_pos) && _pos.getZ() <= blockBox.maxZ()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            _pos = bpos.east();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && level.isEmptyBlock(_pos) && _pos.getX() <= blockBox.maxX()) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            _pos = bpos.west();
            if (random.nextInt(8) != 0 || context.BLOCKS.contains(_pos) || !level.isEmptyBlock(_pos) || _pos.getX() < blockBox.minX()) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
    }

    private void buildBigCircle(BlockPos pos, int length, int count, int iteration, double angle, double size, RandomSource random, StructureGeneratorThreadContext context) {
        if (iteration < 0) {
            return;
        }
        List<List<BlockPos>> lines = this.circleLinesEnds(pos, angle, count, length, (double)Math.abs(length) * 0.7, random);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.nextDouble() * angle * 0.75;
        for (List<BlockPos> line : lines) {
            this.buildLine(line, size, context);
            this.buildBigCircle(line.get(1), length, count, iteration - 1, angle, sizeSmall, random, context);
        }
    }

    private void buildLine(List<BlockPos> blocks, double radius, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.getY() < a.getY()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.getY() - a.getY())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.getY(); y <= b.getY(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.getY()) / max), radius, context);
            }
        }
    }

    private BlockPos lerp(BlockPos start, BlockPos end, double mix) {
        double x = Mth.lerp((double)mix, (double)start.getX(), (double)end.getX());
        double y = Mth.lerp((double)mix, (double)start.getY(), (double)end.getY());
        double z = Mth.lerp((double)mix, (double)start.getZ(), (double)end.getZ());
        return new BlockPos((int)x, (int)y, (int)z);
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, int y, double mix) {
        double v = this.lcos(mix);
        double x = Mth.lerp((double)v, (double)start.getX(), (double)end.getX());
        double z = Mth.lerp((double)v, (double)start.getZ(), (double)end.getZ());
        return new BlockPos((int)x, y, (int)z);
    }

    private double lcos(double mix) {
        return Mth.clamp((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> line(BlockPos start, BlockPos end, int count, RandomSource random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = Mth.lerp((double)delta, (double)start.getX(), (double)end.getX()) + random.nextGaussian() * range;
            double y = Mth.lerp((double)delta, (double)start.getY(), (double)end.getY());
            double z = Mth.lerp((double)delta, (double)start.getZ(), (double)end.getZ()) + random.nextGaussian() * range;
            result.add(new BlockPos((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(BlockPos pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.getX() - radius);
        int z1 = MHelper.floor((double)pos.getZ() - radius);
        int x2 = MHelper.floor((double)pos.getX() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.getZ() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.getX();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.getZ();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.getY() * 0.5, (double)z * 0.5) * 0.25 + 0.75))) continue;
                context.BLOCKS.add(new BlockPos(x, pos.getY(), z));
            }
        }
    }

    private List<List<BlockPos>> circleLinesEnds(BlockPos pos, double startAngle, int count, int height, double radius, RandomSource random) {
        ArrayList<List<BlockPos>> result = new ArrayList<List<BlockPos>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.getX() + Math.sin(startAngle) * radius;
            double z = (double)pos.getZ() + Math.cos(startAngle) * radius;
            BlockPos end = new BlockPos((int)x, (int)((double)(pos.getY() + height) + (double)height * random.nextDouble() * 0.5), (int)z);
            ArrayList<BlockPos> elem = new ArrayList<BlockPos>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(ServerLevelAccessor world, BlockPos pos, double radius, BoundingBox bounds) {
        if (!world.getBlockState(pos).canBeReplaced()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.getX() - radius);
        int z1 = MHelper.floor((double)pos.getZ() - radius);
        int x2 = MHelper.floor((double)pos.getX() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.getZ() + radius + 1.0);
        radius *= radius;
        ArrayList<BlockPos> placed = new ArrayList<BlockPos>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.getX();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                BlockPos p;
                int pz2 = z - pos.getZ();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.getBlockState(p = new BlockPos(x, pos.getY(), z)).canBeReplaced() || !bounds.isInside((Vec3i)p)) continue;
                placed.add(p);
            }
        }
        for (BlockPos p : placed) {
            boolean north = world.getBlockState(p.north()).getBlock() != NetherBlocks.GIANT_LUCIS;
            boolean south = world.getBlockState(p.south()).getBlock() != NetherBlocks.GIANT_LUCIS;
            boolean east = world.getBlockState(p.east()).getBlock() != NetherBlocks.GIANT_LUCIS;
            boolean west = world.getBlockState(p.west()).getBlock() != NetherBlocks.GIANT_LUCIS;
            BlockState state = NetherBlocks.GIANT_LUCIS.defaultBlockState();
            BlocksHelper.setWithUpdate((LevelAccessor)world, p, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(west)));
        }
    }
}

