/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betternether.recipes;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.betterx.bclib.api.v3.datagen.LootDropProvider;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.provider.WoverLootTableProvider;
import org.jetbrains.annotations.NotNull;

public class NetherBlockLootTableProvider
extends WoverLootTableProvider {
    private final List<String> modIDs;

    public NetherBlockLootTableProvider(ModCore modCore) {
        super(modCore, "BetterNether Block Loot", LootContextParamSets.BLOCK);
        this.modIDs = List.of(modCore.modId);
    }

    protected void boostrap(@NotNull HolderLookup.Provider lookup, @NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!(block instanceof LootDropProvider)) continue;
            LootDropProvider dropper = (LootDropProvider)block;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (id == null || !this.shouldInclude(id)) continue;
            LootTable.Builder builder = LootTable.lootTable();
            dropper.getDroppedItemsBCL(builder);
            biConsumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id.withPrefix("block/")), builder);
        }
    }

    private boolean shouldInclude(ResourceLocation id) {
        return this.modIDs == null || this.modIDs.isEmpty() || this.modIDs.contains(id.getNamespace());
    }
}

