/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.network;

import de.ambertation.wunderlib.network.NetworkPayload;
import de.ambertation.wunderlib.network.PacketHandler;
import de.ambertation.wunderlib.network.PacketSender;
import de.ambertation.wunderlib.network.SendToServerAdapter;
import de.ambertation.wunderlib.network.ServerBoundNetworkPayload;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.ApiStatus;

public class ServerBoundPacketHandler<T extends ServerBoundNetworkPayload<T>>
extends PacketHandler<T> {
    private static final List<ServerBoundPacketHandler<?>> packetHandlers = new LinkedList();
    private static PayloadRegistrar registrar;
    private static SendToServerAdapter sendToServerAdapter;

    @ApiStatus.Internal
    static void registerAdapter(SendToServerAdapter adapter) {
        sendToServerAdapter = adapter;
    }

    @ApiStatus.Internal
    public static void registerPayloads(PayloadRegistrar registrar) {
        ServerBoundPacketHandler.registrar = registrar;
        for (ServerBoundPacketHandler<?> packetHandler : packetHandlers) {
            ServerBoundPacketHandler.registerPayload(registrar, packetHandler);
        }
        packetHandlers.clear();
    }

    public ServerBoundPacketHandler(ResourceLocation channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        super(channel, factory);
    }

    public static <T extends ServerBoundNetworkPayload<T>> void register(ServerBoundPacketHandler<T> packetHandler) {
        if (registrar != null) {
            ServerBoundPacketHandler.registerPayload(registrar, packetHandler);
        } else {
            packetHandlers.add(packetHandler);
        }
    }

    public static <T extends ServerBoundNetworkPayload<T>> ServerBoundPacketHandler<T> register(ResourceLocation channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        ServerBoundPacketHandler<T> packetHandler = new ServerBoundPacketHandler<T>(channel, factory);
        ServerBoundPacketHandler.register(packetHandler);
        return packetHandler;
    }

    public static <T extends ServerBoundNetworkPayload<T>> void sendToServer(T payload) {
        payload.prepareOnClient();
        if (sendToServerAdapter != null) {
            sendToServerAdapter.sendToServer(payload);
        } else {
            PacketDistributor.sendToServer(payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static <T extends ServerBoundNetworkPayload<T>> void registerPayload(PayloadRegistrar registrar, ServerBoundPacketHandler<T> packetHandler) {
        registrar.playToServer(packetHandler.CHANNEL, packetHandler.STREAM_CODEC, packetHandler::receiveOnServer);
    }

    private void receiveOnServer(T payload, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        PacketSender responseSender = reply -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)reply, (CustomPacketPayload[])new CustomPacketPayload[0]);
        ((ServerBoundNetworkPayload)payload).processOnServer(player, responseSender);
        CompletableFuture future = context.enqueueWork(() -> {
            MinecraftServer server = player.getServer();
            if (server != null) {
                payload.processOnGameThread(server, player);
            }
        });
        if (((NetworkPayload)payload).isBlocking()) {
            future.join();
        }
    }
}

