/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.AbstractStack;
import de.ambertation.wunderlib.ui.layout.components.Empty;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.components.input.RelativeContainerEventHandler;
import de.ambertation.wunderlib.ui.layout.components.render.NullRenderer;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractHorizontalStack<S extends AbstractHorizontalStack<S>>
extends AbstractStack<NullRenderer, S>
implements RelativeContainerEventHandler {
    public AbstractHorizontalStack(Value width, Value height) {
        super(width, height);
    }

    @Override
    public int updateContainerWidth(int containerWidth) {
        int myWidth = this.width.calculateOrFill(containerWidth);
        int fixedWidth = this.components.stream().map(c -> c.width.calculate(myWidth)).reduce(0, Integer::sum);
        int freeWidth = Math.max(0, myWidth - fixedWidth);
        this.fillWidth(myWidth, freeWidth);
        for (LayoutComponent c2 : this.components) {
            c2.updateContainerWidth(c2.width.calculatedSize());
        }
        return myWidth;
    }

    @Override
    protected int updateContainerHeight(int containerHeight) {
        int myHeight = this.height.calculateOrFill(containerHeight);
        this.components.stream().forEach(c -> c.height.calculateOrFill(myHeight));
        for (LayoutComponent c2 : this.components) {
            c2.updateContainerHeight(c2.height.calculatedSize());
        }
        return myHeight;
    }

    @Override
    void setRelativeBounds(int left, int top) {
        super.setRelativeBounds(left, top);
        int offset = 0;
        for (LayoutComponent c : this.components) {
            int delta = this.relativeBounds.height - c.height.calculatedSize();
            if (c.vAlign == Alignment.MIN) {
                delta = 0;
            } else if (c.vAlign == Alignment.CENTER) {
                delta /= 2;
            }
            c.setRelativeBounds(offset, delta);
            offset += c.relativeBounds.width;
        }
    }

    @Override
    public int getContentWidth() {
        int fixedWidth = this.components.stream().map(c -> c.width.calculateFixed()).reduce(0, Integer::sum);
        double percentage = this.components.stream().map(c -> c.width.calculateRelative()).reduce(0.0, Double::sum);
        return (int)((double)fixedWidth / (1.0 - percentage));
    }

    @Override
    public int getContentHeight() {
        return this.components.stream().map(c -> c.height.calculateFixed()).reduce(0, Integer::max);
    }

    @Override
    protected S addEmpty(Value size) {
        this.components.add(new Empty(size, Value.fixed(0)));
        return (S)this;
    }

    protected VerticalStack addColumn(Value width, Value height) {
        VerticalStack stack = new VerticalStack(width, height);
        this.add(stack);
        return stack;
    }

    protected VerticalStack addColumn() {
        return this.addColumn(Value.fit(), Value.fit());
    }
}

