/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.utils;

import net.minecraft.util.Mth;

public class ColorUtilARGB32 {
    public static int color(int rgb, int alpha) {
        return (alpha & 0xFF) << 24 | rgb & 0xFFFFFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int color(int red, int green, int blue) {
        return ColorUtilARGB32.color(255, red, green, blue);
    }

    public static int color(float alpha, float red, float green, float blue) {
        return ColorUtilARGB32.color((int)(alpha * 255.0f), (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    public static int color(float red, float green, float blue) {
        return ColorUtilARGB32.color(1.0f, red, green, blue);
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int withAlpha(int color, int alpha) {
        return (alpha & 0xFF) << 24 | color & 0xFFFFFF;
    }

    public static int opaque(int color) {
        return ColorUtilARGB32.withAlpha(color, 255);
    }

    public static int lerp(int color1, int color2, float amount) {
        if (amount <= 0.0f) {
            return color1;
        }
        if (amount >= 1.0f) {
            return color2;
        }
        return ColorUtilARGB32.color(Mth.lerpInt((float)amount, (int)ColorUtilARGB32.alpha(color1), (int)ColorUtilARGB32.alpha(color2)), Mth.lerpInt((float)amount, (int)ColorUtilARGB32.red(color1), (int)ColorUtilARGB32.red(color2)), Mth.lerpInt((float)amount, (int)ColorUtilARGB32.green(color1), (int)ColorUtilARGB32.green(color2)), Mth.lerpInt((float)amount, (int)ColorUtilARGB32.blue(color1), (int)ColorUtilARGB32.blue(color2)));
    }
}

