/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.builder;

import com.google.common.collect.Lists;
import de.ambertation.wunderlib.ui.ColorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.biome.api.builder.BiomeSurfaceRuleBuilder;
import org.betterx.wover.biome.api.builder.WoverOverworldBiomesAccess;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.impl.builder.BiomeSurfaceRuleBuilderImpl;
import org.betterx.wover.biome.mixin.BiomeGenerationSettingsAccessor;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.feature.api.placed.PlacedFeatureManager;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.surface.api.AssignedSurfaceRule;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BiomeBuilder<B extends BiomeBuilder<B>> {
    public final BiomeKey<B> key;
    public final BiomeBootstrapContext bootstrapContext;
    public static int DEFAULT_WATER_FOG_COLOR = 329011;
    public static int DEFAULT_WATER_COLOR;
    public static int DEFAULT_NETHER_WATER_COLOR;
    public static int DEFAULT_END_WATER_COLOR;
    public static int DEFAULT_NETHER_WATER_FOG_COLOR;
    public static int DEFAULT_END_WATER_FOG_COLOR;
    public static int DEFAULT_FOG_COLOR;
    public static int DEFAULT_END_FOG_COLOR;
    public static int DEFAULT_END_SKY_COLOR;
    public static float DEFAULT_NETHER_TEMPERATURE;
    public static float DEFAULT_END_TEMPERATURE;
    public static float DEFAULT_NETHER_WETNESS;
    public static float DEFAULT_END_WETNESS;
    protected final List<Climate.ParameterPoint> parameters = new ArrayList<Climate.ParameterPoint>(1);
    @Nullable
    protected TagKey<Biome> intendedPlacement = null;
    protected float fogDensity;
    protected final List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>(2);
    @Nullable
    private BiomeSurfaceRuleBuilderImpl<B> surfaceBuilder;

    public static int calculateSkyColor(float temperature) {
        return WoverOverworldBiomesAccess.calculateSkyColor(temperature);
    }

    protected BiomeBuilder(BiomeBootstrapContext context, BiomeKey<B> key) {
        this.key = key;
        this.bootstrapContext = context;
        this.fogDensity = 1.0f;
    }

    public B addClimate(Climate.ParameterPoint point) {
        this.parameters.add(point);
        return (B)this;
    }

    public B addNetherClimate(float temperature, float humidity, float offset) {
        return this.addClimate(Climate.parameters((float)temperature, (float)humidity, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)offset));
    }

    public B addNetherClimate(float temperature, float humidity) {
        return this.addNetherClimate(temperature, humidity, 0.0f);
    }

    public B fogDensity(float density) {
        this.fogDensity = density;
        return (B)this;
    }

    public B structure(StructureKey<?, ?, ?> structure) {
        return this.tag(structure.biomeTag());
    }

    public B structure(TagKey<Biome> structureTag) {
        return this.tag(structureTag);
    }

    protected B biomeTypeTag(TagKey<Biome> tag) {
        if (this.intendedPlacement == null && tag != null) {
            this.intendedPlacement = tag;
        }
        return this.tag(tag);
    }

    @SafeVarargs
    public final B tag(TagKey<Biome> ... tags) {
        for (TagKey<Biome> biomeTag : tags) {
            if (biomeTag == null || this.biomeTags.contains(biomeTag)) continue;
            this.biomeTags.add(biomeTag);
        }
        return (B)this;
    }

    public BiomeSurfaceRuleBuilder<B> startSurface() {
        this.surfaceBuilder = new BiomeSurfaceRuleBuilderImpl<BiomeBuilder>(this.key, this);
        return this.surfaceBuilder;
    }

    public B surface(BlockState state) {
        return ((BiomeSurfaceRuleBuilder)this.startSurface().surface(state)).finishSurface();
    }

    public B surface(Block block) {
        return ((BiomeSurfaceRuleBuilder)this.startSurface().surface(block)).finishSurface();
    }

    public B surface(BlockState top, BlockState under) {
        return ((BiomeSurfaceRuleBuilder)((BiomeSurfaceRuleBuilder)this.startSurface().surface(top)).subsurface(under, 3)).finishSurface();
    }

    public B surface(Block top, Block under) {
        return ((BiomeSurfaceRuleBuilder)((BiomeSurfaceRuleBuilder)this.startSurface().surface(top)).subsurface(under, 3)).finishSurface();
    }

    public B intendedPlacement(TagKey<Biome> biome) {
        this.intendedPlacement = biome;
        return (B)this;
    }

    public void register() {
        this.bootstrapContext.register(this);
    }

    public abstract void registerBiome(BootstrapContext<Biome> var1);

    public abstract void registerBiomeData(BootstrapContext<BiomeData> var1);

    public void registerBiomeTags(TagBootstrapContext<Biome> context) {
        for (TagKey<Biome> biomeTag : this.biomeTags) {
            context.add(biomeTag, this.key.key);
        }
    }

    public void registerSurfaceRule(@NotNull BootstrapContext<AssignedSurfaceRule> context) {
        if (this.surfaceBuilder != null) {
            this.surfaceBuilder.register(context);
        }
    }

    static {
        DEFAULT_NETHER_WATER_COLOR = DEFAULT_WATER_COLOR = 4159204;
        DEFAULT_END_WATER_COLOR = DEFAULT_WATER_COLOR;
        DEFAULT_END_WATER_FOG_COLOR = DEFAULT_NETHER_WATER_FOG_COLOR = 329011;
        DEFAULT_FOG_COLOR = 12638463;
        DEFAULT_END_FOG_COLOR = 0xA080A0;
        DEFAULT_END_SKY_COLOR = 0;
        DEFAULT_NETHER_TEMPERATURE = 2.0f;
        DEFAULT_END_TEMPERATURE = 0.5f;
        DEFAULT_NETHER_WETNESS = 0.0f;
        DEFAULT_END_WETNESS = 0.5f;
    }

    public static abstract class Wrapped
    extends BiomeBuilder<Wrapped> {
        protected Wrapped(BiomeBootstrapContext context, BiomeKey<Wrapped> key) {
            super(context, key);
        }
    }

    public static abstract class Vanilla
    extends VanillaBuilder<Vanilla> {
        protected Vanilla(BiomeBootstrapContext context, BiomeKey<Vanilla> key) {
            super(context, key);
        }
    }

    public static abstract class VanillaBuilder<B extends VanillaBuilder<B>>
    extends BiomeBuilder<B> {
        private Biome.TemperatureModifier temperatureModifier;
        private float downfall = 0.0f;
        private float temperature = 0.5f;
        private boolean hasPrecipitation = false;
        private final BiomeSpecialEffects.Builder fx = new BiomeSpecialEffects.Builder();
        private final BiomeGenerationSettings.Builder generationSettings;
        private final MobSpawnSettings.Builder mobSpawnSettings = new MobSpawnSettings.Builder();

        protected VanillaBuilder(BiomeBootstrapContext context, BiomeKey<B> key) {
            super(context, key);
            this.temperatureModifier = Biome.TemperatureModifier.NONE;
            this.generationSettings = new BiomeGenerationSettings.Builder(this.bootstrapContext.lookup(Registries.PLACED_FEATURE), this.bootstrapContext.lookup(Registries.CONFIGURED_CARVER));
            this.fx.fogColor(DEFAULT_FOG_COLOR);
            this.fx.waterFogColor(DEFAULT_WATER_FOG_COLOR);
            this.fx.waterColor(DEFAULT_WATER_COLOR);
            this.fx.skyColor(VanillaBuilder.calculateSkyColor(this.temperature));
        }

        public B hasPrecipitation(boolean bl) {
            this.hasPrecipitation = bl;
            return (B)this;
        }

        public B temperature(float f) {
            this.temperature = f;
            return (B)this;
        }

        public B downfall(float f) {
            this.downfall = f;
            return (B)this;
        }

        public B temperatureAdjustment(Biome.TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return (B)this;
        }

        public B temperatureFrozen() {
            return this.temperatureAdjustment(Biome.TemperatureModifier.FROZEN);
        }

        public B temperatureRegular() {
            return this.temperatureAdjustment(Biome.TemperatureModifier.NONE);
        }

        public B feature(BasePlacedFeatureKey<?> feature) {
            this.generationSettings.addFeature(feature.getDecoration(), feature.getHolder(this.bootstrapContext.lookup(Registries.PLACED_FEATURE)));
            return (B)this;
        }

        public B feature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            this.generationSettings.addFeature(decoration, PlacedFeatureManager.getHolder(this.bootstrapContext.lookup(Registries.PLACED_FEATURE), feature));
            return (B)this;
        }

        public B feature(GenerationStep.Decoration decoration, Holder<PlacedFeature> feature) {
            this.generationSettings.addFeature(decoration, feature);
            return (B)this;
        }

        public B feature(Consumer<BiomeGenerationSettings.Builder> featureAdd) {
            featureAdd.accept(this.generationSettings);
            return (B)this;
        }

        public B defaultMushrooms() {
            return this.feature(BiomeDefaultFeatures::addDefaultMushrooms);
        }

        public B netherDefaultOres() {
            return this.feature(BiomeDefaultFeatures::addNetherDefaultOres);
        }

        public B carver(GenerationStep.Carving step, ResourceKey<ConfiguredWorldCarver<?>> carver) {
            this.generationSettings.addCarver(step, (Holder)this.bootstrapContext.lookup(Registries.CONFIGURED_CARVER).getOrThrow(carver));
            return (B)this;
        }

        public B carver(GenerationStep.Carving step, Holder<ConfiguredWorldCarver<?>> carver) {
            this.generationSettings.addCarver(step, carver);
            return (B)this;
        }

        public B fogColor(int color) {
            this.fx.fogColor(color);
            return (B)this;
        }

        public B fogColor(int r, int g, int b) {
            this.fx.fogColor(ColorHelper.color((int)r, (int)g, (int)b));
            return (B)this;
        }

        public B waterColor(int r, int g, int b) {
            return this.waterColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B waterColor(int color) {
            this.fx.waterColor(color);
            return (B)this;
        }

        public B waterFogColor(int r, int g, int b) {
            return this.waterFogColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B waterFogColor(int color) {
            this.fx.waterFogColor(color);
            return (B)this;
        }

        public B skyColor(int r, int g, int b) {
            return this.skyColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B skyColor(int color) {
            this.fx.skyColor(color);
            return (B)this;
        }

        public B foliageColorOverride(int r, int g, int b) {
            return this.foliageColorOverride(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B foliageColorOverride(int color) {
            this.fx.foliageColorOverride(color);
            return (B)this;
        }

        public B grassColorOverride(int r, int g, int b) {
            return this.grassColorOverride(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B grassColorOverride(int color) {
            this.fx.grassColorOverride(color);
            return (B)this;
        }

        public B grassColorModifier(BiomeSpecialEffects.GrassColorModifier grassColorModifier) {
            this.fx.grassColorModifier(grassColorModifier);
            return (B)this;
        }

        public B waterAndFogColor(int color) {
            return ((VanillaBuilder)this.waterColor(color)).waterFogColor(color);
        }

        public B waterAndFogColor(int r, int g, int b) {
            return this.waterAndFogColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B plantsColor(int r, int g, int b) {
            return this.plantsColor(ColorHelper.color((int)r, (int)g, (int)b));
        }

        public B plantsColor(int color) {
            return ((VanillaBuilder)this.grassColorOverride(color)).foliageColorOverride(color);
        }

        public B particles(ParticleOptions particle, float probability) {
            this.particles(new AmbientParticleSettings(particle, probability));
            return (B)this;
        }

        public B particles(AmbientParticleSettings ambientParticleSettings) {
            this.fx.ambientParticle(ambientParticleSettings);
            return (B)this;
        }

        public B loop(Holder<SoundEvent> holder) {
            this.fx.ambientLoopSound(holder);
            return (B)this;
        }

        public B mood(AmbientMoodSettings ambientMoodSettings) {
            this.fx.ambientMoodSound(ambientMoodSettings);
            return (B)this;
        }

        public B mood(Holder<SoundEvent> mood) {
            return this.mood(mood, 6000, 8, 2.0f);
        }

        public B mood(Holder<SoundEvent> mood, int tickDelay, int blockSearchExtent, float soundPositionOffset) {
            return this.mood(new AmbientMoodSettings(mood, tickDelay, blockSearchExtent, (double)soundPositionOffset));
        }

        public B additions(AmbientAdditionsSettings ambientAdditionsSettings) {
            this.fx.ambientAdditionsSound(ambientAdditionsSettings);
            return (B)this;
        }

        public B additions(Holder<SoundEvent> additions, float intensity) {
            return this.additions(new AmbientAdditionsSettings(additions, (double)intensity));
        }

        public B additions(Holder<SoundEvent> additions) {
            return this.additions(additions, 0.0111f);
        }

        public B music(@Nullable Music music) {
            this.fx.backgroundMusic(music);
            return (B)this;
        }

        public B music(Holder<SoundEvent> music) {
            return this.music(music, 600, 2400, true);
        }

        public B music(Holder<SoundEvent> music, int minDelay, int maxDelay, boolean replaceCurrentMusic) {
            return this.music(new Music(music, minDelay, maxDelay, replaceCurrentMusic));
        }

        public final B isNetherBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag((TagKey<Biome>)BiomeTags.IS_NETHER));
        }

        public final B isEndHighlandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag(CommonBiomeTags.IS_END_HIGHLAND));
        }

        public final B isEndMidlandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag(CommonBiomeTags.IS_END_MIDLAND));
        }

        public final B isEndCenterIslandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag(CommonBiomeTags.IS_END_CENTER));
        }

        public final B isEndBarrensBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag(CommonBiomeTags.IS_END_BARRENS));
        }

        public final B isEndSmallIslandBiome() {
            return (B)((VanillaBuilder)this.biomeTypeTag(CommonBiomeTags.IS_SMALL_END_ISLAND));
        }

        public B spawn(EntityType<?> entityType, int weight, int minGroupCount, int maxGroupCount) {
            this.mobSpawnSettings.addSpawn(entityType.getCategory(), new MobSpawnSettings.SpawnerData(entityType, weight, minGroupCount, maxGroupCount));
            return (B)this;
        }

        public B addMobCharge(EntityType<?> entityType, double energyBudget, double charge) {
            this.mobSpawnSettings.addMobCharge(entityType, energyBudget, charge);
            return (B)this;
        }

        public B creatureGenerationProbability(float p) {
            this.mobSpawnSettings.creatureGenerationProbability(p);
            return (B)this;
        }

        @Override
        public void register() {
            this.bootstrapContext.register(this);
        }

        @Override
        public void registerBiome(BootstrapContext<Biome> biomeContext) {
            biomeContext.register(this.key.key, (Object)this.buildBiome());
        }

        @Override
        public abstract void registerBiomeData(BootstrapContext<BiomeData> var1);

        private static BiomeGenerationSettings fixGenerationSettings(BiomeGenerationSettings settings) {
            if (settings instanceof BiomeGenerationSettingsAccessor) {
                BiomeGenerationSettingsAccessor acc = (BiomeGenerationSettingsAccessor)settings;
                HashMap carvers = new HashMap(acc.wover_getCarvers());
                for (GenerationStep.Carving step : GenerationStep.Carving.values()) {
                    carvers.computeIfAbsent(step, __ -> HolderSet.direct((List)Lists.newArrayList()));
                }
                acc.wover_setCarvers(Map.copyOf(carvers));
            }
            return settings;
        }

        protected Biome buildBiome() {
            Biome.BiomeBuilder vanillaBuilder = new Biome.BiomeBuilder();
            vanillaBuilder.hasPrecipitation(this.hasPrecipitation);
            vanillaBuilder.downfall(this.downfall);
            vanillaBuilder.temperature(this.temperature);
            vanillaBuilder.temperatureAdjustment(this.temperatureModifier);
            vanillaBuilder.generationSettings(VanillaBuilder.fixGenerationSettings(this.generationSettings.build()));
            vanillaBuilder.specialEffects(this.fx.build());
            vanillaBuilder.mobSpawnSettings(this.mobSpawnSettings.build());
            return vanillaBuilder.build();
        }
    }
}

