/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.modification;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.configs.AbstractConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.betterx.wover.biome.api.modification.BiomeModificationRegistry;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.impl.modification.BiomeModificationImpl;
import org.betterx.wover.biome.impl.modification.FeatureMap;
import org.betterx.wover.biome.impl.modification.GenerationSettingsWorker;
import org.betterx.wover.biome.impl.modification.MobSettingsWorker;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.structure.api.StructureKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BiomeModification {
    public static final Codec<BiomeModification> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomePredicate.CODEC.fieldOf("predicate").forGetter(BiomeModification::predicate), (App)FeatureMap.CODEC.optionalFieldOf("features", List.of()).forGetter(BiomeModification::features), (App)TagKey.codec((ResourceKey)Registries.BIOME).listOf().optionalFieldOf("biome_tags", List.of()).forGetter(BiomeModification::biomeTags), (App)Codec.list((Codec)MobSpawnSettings.SpawnerData.CODEC).optionalFieldOf("spawns", List.of()).forGetter(BiomeModification::spawns)).apply((Applicative)instance, BiomeModificationImpl::new));

    public BiomePredicate predicate();

    public List<List<Holder<PlacedFeature>>> features();

    public List<MobSpawnSettings.SpawnerData> spawns();

    public List<TagKey<Biome>> biomeTags();

    @ApiStatus.Internal
    public void apply(GenerationSettingsWorker var1, MobSettingsWorker var2);

    public static Builder build(@NotNull BootstrapContext<BiomeModification> context, @NotNull ResourceLocation location) {
        return new Builder(context, (ResourceKey<BiomeModification>)ResourceKey.create(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY, (ResourceLocation)location));
    }

    public static Builder build(@NotNull BootstrapContext<BiomeModification> context, @NotNull ResourceKey<BiomeModification> key) {
        return new Builder(context, key);
    }

    public static final class Builder {
        @Nullable
        private final BootstrapContext<BiomeModification> bootstrapContext;
        private BiomePredicate predicate;
        private final FeatureMap features;
        private final List<MobSpawnSettings.SpawnerData> spawns;
        private final Set<TagKey<Biome>> tags = new HashSet<TagKey<Biome>>();
        private final ResourceKey<BiomeModification> key;

        private Builder(@Nullable BootstrapContext<BiomeModification> bootstrapContext, ResourceKey<BiomeModification> key) {
            this.bootstrapContext = bootstrapContext;
            this.key = key;
            this.predicate = BiomePredicate.always();
            this.features = FeatureMap.of(new ArrayList<List<Holder<PlacedFeature>>>(GenerationStep.Decoration.values().length));
            this.spawns = new ArrayList<MobSpawnSettings.SpawnerData>(2);
        }

        public Builder predicate(BiomePredicate p) {
            this.predicate = p;
            return this;
        }

        public Builder isBiome(ResourceKey<Biome> key) {
            this.predicate(BiomePredicate.isBiome(key));
            return this;
        }

        @SafeVarargs
        public final Builder inBiomes(ResourceKey<Biome> ... keys) {
            return this.predicate(BiomePredicate.inBiomes(keys));
        }

        @SafeVarargs
        public final Builder notInBiomes(ResourceKey<Biome> ... keys) {
            return this.predicate(BiomePredicate.notInBiomes(keys));
        }

        public Builder inDimension(ResourceKey<LevelStem> key) {
            return this.predicate(BiomePredicate.inDimension(key));
        }

        public Builder inOverworld() {
            return this.predicate(BiomePredicate.inOverworld());
        }

        public Builder inEnd() {
            return this.predicate(BiomePredicate.inEnd());
        }

        public Builder inNether() {
            return this.predicate(BiomePredicate.inNether());
        }

        public Builder hasTag(TagKey<Biome> tag) {
            return this.predicate(BiomePredicate.hasTag(tag));
        }

        public Builder spawns(EntityType<?> type) {
            return this.predicate(BiomePredicate.spawns(type));
        }

        public Builder hasStructure(ResourceKey<Structure> key) {
            return this.predicate(BiomePredicate.hasStructure(key));
        }

        public Builder hasPlacedFeature(ResourceKey<PlacedFeature> key) {
            return this.predicate(BiomePredicate.hasPlacedFeature(key));
        }

        public Builder hasConfiguredFeature(ResourceKey<ConfiguredFeature<?, ?>> key) {
            return this.predicate(BiomePredicate.hasConfiguredFeature(key));
        }

        public Builder anyOf(BiomePredicate ... predicates) {
            return this.predicate(BiomePredicate.or(predicates));
        }

        public Builder allOf(BiomePredicate ... predicates) {
            return this.predicate(BiomePredicate.and(predicates));
        }

        public Builder not(BiomePredicate predicate) {
            return this.predicate(BiomePredicate.not(predicate));
        }

        public Builder isVanilla() {
            return this.predicate(BiomePredicate.isVanilla());
        }

        public Builder inNamespace(String namespace) {
            return this.predicate(BiomePredicate.inNamespace(namespace));
        }

        public Builder inNamespace(ModCore core) {
            return this.predicate(BiomePredicate.inNamespace(core));
        }

        public Builder notInNamespace(String namespace) {
            return this.predicate(BiomePredicate.notInNamespace(namespace));
        }

        public Builder notInNamespace(ModCore core) {
            return this.predicate(BiomePredicate.inNamespace(core));
        }

        public <T, R extends AbstractConfig.Value<T, R>> Builder hasConfig(AbstractConfig.Value<T, R> value, T targetValue) {
            return this.predicate(BiomePredicate.hasConfig(value, targetValue));
        }

        public Builder addFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> featureKey) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a ResourceKey for a PlacedFeature to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            Holder.Reference holder = this.bootstrapContext.lookup(Registries.PLACED_FEATURE).getOrThrow(featureKey);
            return this.addFeature(decoration, (Holder<PlacedFeature>)holder);
        }

        public Builder addFeature(GenerationStep.Decoration decoration, Holder<PlacedFeature> holder) {
            this.features.getFeatures(decoration).add(holder);
            return this;
        }

        public Builder addFeature(BasePlacedFeatureKey<?> feature) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a PlacedFeatureKey to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            return this.addFeature(feature.getDecoration(), feature.getHolder(this.bootstrapContext));
        }

        public Builder addStructureSet(StructureKey<?, ?, ?> structure) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a Structure to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            return this.addToTag(structure.biomeTag());
        }

        public Builder addStructureSet(TagKey<Biome> structureSet) {
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You can not add a Structure to a Biome Modification if no Bootstrap Context was supplied (" + String.valueOf(this.key) + ").");
            }
            return this.addToTag(structureSet);
        }

        public <M extends Mob> Builder addSpawn(EntityType<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
            return this.addSpawn(new MobSpawnSettings.SpawnerData(entityType, weight, minGroupCount, maxGroupCount));
        }

        public <M extends Mob> Builder addSpawn(MobSpawnSettings.SpawnerData spawnerData) {
            this.spawns.add(spawnerData);
            return this;
        }

        public Builder addToTag(TagKey<Biome> tag) {
            this.tags.add(tag);
            return this;
        }

        public Holder<BiomeModification> directHolder() {
            return Holder.direct((Object)this.build());
        }

        public Holder<BiomeModification> register() {
            if (this.key == null) {
                throw new IllegalStateException("You need to specify a key when you register a Biome Modification.");
            }
            if (this.bootstrapContext == null) {
                throw new IllegalStateException("You need to supply a key when you register a Biome Modification (" + String.valueOf(this.key) + ").");
            }
            return this.bootstrapContext.register(this.key, (Object)this.build());
        }

        @NotNull
        private BiomeModificationImpl build() {
            return new BiomeModificationImpl(this.predicate, this.features.generic(), this.tags != null ? this.tags.stream().toList() : null, this.spawns);
        }
    }
}

