/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.base.Stopwatch;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.wover.biome.api.modification.BiomeModification;
import org.betterx.wover.biome.api.modification.BiomeModificationRegistry;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.impl.modification.BiomeTagModificationWorker;
import org.betterx.wover.biome.impl.modification.GenerationSettingsWorker;
import org.betterx.wover.biome.impl.modification.MobSettingsWorker;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.common.generator.api.chunkgenerator.RebuildableFeaturesPerStep;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;

public class BiomeModificationRegistryImpl {
    public static final EventImpl<OnBootstrapRegistry<BiomeModification>> BOOTSTRAP_BIOME_MODIFICATION_REGISTRY = new EventImpl("BOOTSTRAP_BIOME_MODIFICATION_REGISTRY");
    private static boolean didInit = false;

    @ApiStatus.Internal
    public static void initialize() {
        if (didInit) {
            return;
        }
        didInit = true;
        DatapackRegistryBuilder.register(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY, BiomeModification.CODEC, BiomeModificationRegistryImpl::onBootstrap);
        WorldLifecycle.MINECRAFT_SERVER_READY.subscribe(BiomeModificationRegistryImpl::whenReady, 100000000);
    }

    private static void onBootstrap(BootstrapContext<BiomeModification> ctx) {
        BOOTSTRAP_BIOME_MODIFICATION_REGISTRY.emit(c -> c.bootstrap(ctx));
    }

    private static void whenReady(LevelStorageSource.LevelStorageAccess storageSource, PackRepository packRepository, WorldStem worldStem) {
        Registry dimensions;
        Stopwatch sw = Stopwatch.createStarted();
        RegistryAccess registryAccess = WorldState.registryAccess();
        Registry modifications = registryAccess.registry(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY).orElse(null);
        if (modifications == null) {
            LibWoverBiome.C.log.error("Biome Modification Registry is missing. Cannot apply Biome Modifications.");
            return;
        }
        Registry biomes = registryAccess.registryOrThrow(Registries.BIOME);
        List<ResourceKey> keys = biomes.entrySet().stream().map(Map.Entry::getKey).sorted(Comparator.comparingInt(key -> biomes.getId((Object)((Biome)biomes.getOrThrow(key))))).toList();
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        List biomeModifications = modifications.stream().toList();
        int biomesChanged = 0;
        int biomesProcessed = 0;
        int modifiersApplied = 0;
        int tagsAdded = 0;
        for (ResourceKey biomeKey : keys) {
            BiomePredicate.Context context = BiomePredicate.Context.of(registryAccess, (ResourceKey<Biome>)biomeKey);
            if (context == null) {
                LibWoverBiome.C.log.warn("Failed to get biome context for {}", new Object[]{biomeKey.location()});
                continue;
            }
            ++biomesProcessed;
            GenerationSettingsWorker worker = null;
            MobSettingsWorker mobWorker = null;
            boolean didChangeBiome = false;
            for (BiomeModification modification : biomeModifications) {
                if (!modification.predicate().test(context)) continue;
                if (worker == null) {
                    worker = new GenerationSettingsWorker(registryAccess, context.biome);
                }
                if (mobWorker == null) {
                    mobWorker = new MobSettingsWorker(context.biome);
                }
                if (modification.biomeTags() != null) {
                    for (TagKey<Biome> tag : modification.biomeTags()) {
                        if (!biomeTagWorker.addBiomeToTag(tag, context)) continue;
                        ++tagsAdded;
                        didChangeBiome = true;
                    }
                }
                modification.apply(worker, mobWorker);
                ++modifiersApplied;
            }
            if (worker != null && worker.finished()) {
                didChangeBiome = true;
            }
            if (mobWorker != null && mobWorker.finished()) {
                didChangeBiome = true;
            }
            if (!didChangeBiome) continue;
            ++biomesChanged;
        }
        biomeTagWorker.finished();
        if (tagsAdded > 0) {
            dimensions = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
            dimensions.forEach(stem -> {
                BiomeSource patt0$temp = stem.generator().getBiomeSource();
                if (patt0$temp instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource reloadable = (ReloadableBiomeSource)patt0$temp;
                    reloadable.reloadBiomes();
                }
            });
        }
        if (biomesProcessed > 0) {
            dimensions = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
            dimensions.forEach(stem -> {
                ChunkGenerator patt0$temp = stem.generator();
                if (patt0$temp instanceof RebuildableFeaturesPerStep) {
                    RebuildableFeaturesPerStep generator = (RebuildableFeaturesPerStep)patt0$temp;
                    generator.wover_rebuildFeaturesPerStep();
                }
            });
            LibWoverBiome.C.log.info("Applied {} biome modifications and added {} tags to {} of {} biomes in {}", new Object[]{modifiersApplied, tagsAdded, biomesChanged, biomesProcessed, sw.stop()});
        }
    }

    public static ResourceKey<BiomeModification> createKey(ResourceLocation modificationID) {
        return ResourceKey.create(BiomeModificationRegistry.BIOME_MODIFICATION_REGISTRY, (ResourceLocation)modificationID);
    }
}

