/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.biome.impl.modification.FeatureMap;
import org.jetbrains.annotations.NotNull;

public class GenerationSettingsWorker {
    private final Registry<ConfiguredWorldCarver<?>> carvers;
    private final Registry<PlacedFeature> features;
    private final BiomeGenerationSettings generationSettings;
    private final Biome biome;
    Map<GenerationStep.Carving, HolderSet<ConfiguredWorldCarver<?>>> customizedCarvers;
    List<HolderSet<PlacedFeature>> customizedFeatures;

    public GenerationSettingsWorker(RegistryAccess registries, Biome biome) {
        this.biome = biome;
        this.generationSettings = biome.getGenerationSettings();
        this.carvers = registries.registryOrThrow(Registries.CONFIGURED_CARVER);
        this.features = registries.registryOrThrow(Registries.PLACED_FEATURE);
    }

    private void unfreezeCarvers() {
        if (this.customizedCarvers == null) {
            this.generationSettings.carvers = this.customizedCarvers = new EnumMap(GenerationStep.Carving.class);
        }
    }

    private void freezeCarvers() {
        if (this.customizedCarvers != null) {
            this.generationSettings.carvers = ImmutableMap.copyOf(this.customizedCarvers);
            this.customizedCarvers = null;
        }
    }

    private void unfreezeFeatures() {
        if (this.customizedFeatures == null) {
            this.generationSettings.features = this.customizedFeatures = new LinkedList<HolderSet<PlacedFeature>>(this.generationSettings.features);
        }
    }

    private void freezeFeatures() {
        if (this.customizedFeatures != null) {
            this.generationSettings.features = ImmutableList.copyOf(this.customizedFeatures);
            this.generationSettings.featureSet = Suppliers.memoize(this::createPlacedFeatrueSet);
            this.generationSettings.flowerFeatures = Suppliers.memoize(this::createFlowerFeatures);
            this.customizedFeatures = null;
        }
    }

    public boolean finished() {
        boolean res = this.customizedCarvers != null || this.customizedFeatures != null;
        this.freezeCarvers();
        this.freezeFeatures();
        return res;
    }

    private Set<PlacedFeature> createPlacedFeatrueSet() {
        return this.getFlatFeatureStream().collect(Collectors.toSet());
    }

    private List<ConfiguredFeature<?, ?>> createFlowerFeatures() {
        return (List)this.getFlatFeatureStream().flatMap(PlacedFeature::getFeatures).filter(configured -> configured.feature() == Feature.FLOWER).collect(ImmutableList.toImmutableList());
    }

    @NotNull
    private Stream<PlacedFeature> getFlatFeatureStream() {
        return this.generationSettings.features.stream().flatMap(HolderSet::stream).map(Holder::value);
    }

    public void addFeatures(FeatureMap features) {
        int index;
        boolean hasNewFeatures = false;
        for (index = 0; index < features.size(); ++index) {
            if (index >= GenerationStep.Decoration.values().length || ((LinkedList)features.get(index)).isEmpty()) continue;
            hasNewFeatures = true;
            break;
        }
        if (!hasNewFeatures) {
            return;
        }
        this.unfreezeFeatures();
        for (index = 0; index < features.size(); ++index) {
            LinkedList newFeatures;
            if (index >= GenerationStep.Decoration.values().length || (newFeatures = (LinkedList)features.get(index)).isEmpty()) continue;
            GenerationStep.Decoration step = GenerationStep.Decoration.values()[index];
            ArrayList featuresInStep = new ArrayList(FeatureMap.getFeatures(this.customizedFeatures, step).stream().toList());
            featuresInStep.addAll(newFeatures);
            this.customizedFeatures.set(index, (HolderSet<PlacedFeature>)HolderSet.direct(featuresInStep));
        }
    }
}

