/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification.predicates;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.dimension.LevelStem;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;

public record InDimension(ResourceKey<LevelStem> dimensionKey) implements BiomePredicate
{
    public static final InDimension OVERWORLD = new InDimension((ResourceKey<LevelStem>)LevelStem.OVERWORLD);
    public static final InDimension END = new InDimension((ResourceKey<LevelStem>)LevelStem.END);
    public static final InDimension NETHER = new InDimension((ResourceKey<LevelStem>)LevelStem.NETHER);
    public static final KeyDispatchDataCodec<InDimension> CODEC = KeyDispatchDataCodec.of((MapCodec)ResourceKey.codec((ResourceKey)Registries.LEVEL_STEM).xmap(InDimension::new, InDimension::dimensionKey).fieldOf("dimension_key"));

    @Override
    public KeyDispatchDataCodec<? extends BiomePredicate> codec() {
        return CODEC;
    }

    @Override
    public boolean test(BiomePredicate.Context ctx) {
        LevelStem dimension = (LevelStem)ctx.levelStems.get(this.dimensionKey);
        if (dimension == null) {
            return false;
        }
        return dimension.generator().getBiomeSource().possibleBiomes().stream().map(Holder::unwrapKey).filter(Optional::isPresent).map(Optional::get).anyMatch(entry -> entry.equals(ctx.biomeKey));
    }
}

