/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.wover.block.api.model.WoverBlockModelGeneratorsAccess;
import org.betterx.wover.entrypoint.LibWoverBlock;
import org.jetbrains.annotations.Nullable;

public class WoverBlockModelGenerators {
    public static final ResourceLocation CROSS = ResourceLocation.withDefaultNamespace((String)"block/cross");
    public static final ResourceLocation CUBE = ResourceLocation.withDefaultNamespace((String)"block/cube");
    public static final ResourceLocation CUBE_ALL = ResourceLocation.withDefaultNamespace((String)"block/cube_all");
    public static final ResourceLocation COMPOSTER = LibWoverBlock.C.id("block/composter");
    public static final ModelTemplate COMPOSTER_MODEL = new ModelTemplate(Optional.of(COMPOSTER), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.BOTTOM, TextureSlot.TOP});
    public final WoverBlockModelGeneratorsAccess vanillaGenerator;
    private final Map<ResourceLocation, ResourceLocation> PARTICLE_ONLY_MODELS = Maps.newHashMap();

    public WoverBlockModelGenerators(BlockModelGenerators vanillaGenerator) {
        WoverBlockModelGeneratorsAccess access;
        if (!(vanillaGenerator instanceof WoverBlockModelGeneratorsAccess)) {
            throw new IllegalArgumentException("Expected WoverBlockModelGeneratorsAccess");
        }
        this.vanillaGenerator = access = (WoverBlockModelGeneratorsAccess)vanillaGenerator;
    }

    public void createObsidianVariants(WoverBlockModelGenerators generators, Block obsidianBlock) {
        TexturedModel model = generators.getTextureModels(obsidianBlock, TexturedModel.CUBE.get(obsidianBlock));
        ModelTemplate template = model.getTemplate();
        ResourceLocation modelLocation = template.create(obsidianBlock, model.getMapping(), generators.vanillaGenerator.modelOutput());
        VariantProperties.Rotation[] rotations = new VariantProperties.Rotation[]{VariantProperties.Rotation.R0, VariantProperties.Rotation.R90, VariantProperties.Rotation.R180, VariantProperties.Rotation.R270};
        Variant[] variants = new Variant[16];
        int idx = 0;
        for (VariantProperties.Rotation rotation : rotations) {
            for (VariantProperties.Rotation rotationY : rotations) {
                variants[idx] = Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation);
                if (rotation != VariantProperties.Rotation.R0) {
                    variants[idx] = variants[idx].with(VariantProperties.X_ROT, (Object)rotation);
                }
                if (rotationY != VariantProperties.Rotation.R0) {
                    variants[idx] = variants[idx].with(VariantProperties.Y_ROT, (Object)rotationY);
                }
                ++idx;
            }
        }
        generators.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)obsidianBlock, (Variant[])variants));
    }

    public void acceptBlockState(BlockStateGenerator blockStateGenerator) {
        this.vanillaGenerator.blockStateOutput().accept(blockStateGenerator);
    }

    public void acceptModelOutput(ResourceLocation id, Supplier<JsonElement> supplier) {
        this.vanillaGenerator.modelOutput().accept(id, supplier);
    }

    public void delegateItemModel(Block block) {
        this.vanillaGenerator.delegateItemModel(block, TextureMapping.getBlockTexture((Block)block));
    }

    public void delegateItemModel(Block block, ResourceLocation resourceLocation) {
        this.vanillaGenerator.delegateItemModel(block, resourceLocation);
    }

    public TexturedModel getTextureModels(Block block, TexturedModel defaultModel) {
        return this.vanillaGenerator.texturedModels().getOrDefault(block, defaultModel);
    }

    public Builder modelFor(Block block) {
        TexturedModel texturedModel = this.getTextureModels(block, TexturedModel.CUBE.get(block));
        return this.modelFor(texturedModel);
    }

    public Builder modelFor(TexturedModel texturedModel) {
        return new Builder(texturedModel, texturedModel.getMapping());
    }

    public Builder modelFor(TexturedModel texturedModel, TextureMapping textureMapping) {
        return new Builder(texturedModel, textureMapping);
    }

    public Builder modelFor(Block block, TextureMapping textureMappingOverride) {
        TexturedModel texturedModel = this.getTextureModels(block, TexturedModel.CUBE.get(block));
        return new Builder(texturedModel, textureMappingOverride);
    }

    public static TextureMapping textureMappingOf(TextureSlot slotA, ResourceLocation locationA) {
        return new TextureMapping().put(slotA, locationA);
    }

    public static TextureMapping textureMappingOf(TextureSlot slotA, ResourceLocation locationA, TextureSlot slotB, ResourceLocation locationB) {
        return WoverBlockModelGenerators.textureMappingOf(slotA, locationA).put(slotB, locationB);
    }

    public void createBookshelf(Block shelf, Block planks) {
        TextureMapping textureMapping = TextureMapping.column((ResourceLocation)TextureMapping.getBlockTexture((Block)shelf), (ResourceLocation)TextureMapping.getBlockTexture((Block)planks));
        ResourceLocation resourceLocation = ModelTemplates.CUBE_COLUMN.create(shelf, textureMapping, this.vanillaGenerator.modelOutput());
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(shelf, resourceLocation));
    }

    public void createLadder(Block ladderBlock) {
        this.vanillaGenerator.createNonTemplateHorizontalBlock(ladderBlock);
        this.vanillaGenerator.createSimpleFlatItemModel(ladderBlock);
    }

    public void createCrossBlock(Block block, boolean tinted) {
        TextureMapping mapping = TextureMapping.cross((Block)block);
        ModelTemplate template = tinted ? ModelTemplates.TINTED_CROSS : ModelTemplates.CROSS;
        ResourceLocation modelLocation = template.create(block, mapping, this.vanillaGenerator.modelOutput());
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(block, modelLocation));
    }

    public ResourceLocation particleOnlyModel(Block block) {
        ResourceLocation name = ModelLocationUtils.getModelLocation((Block)block).withSuffix("_particles");
        if (name.getNamespace().equals("minecraft")) {
            name = LibWoverBlock.C.mk(name.getPath());
        }
        ResourceLocation finalName = name;
        return this.PARTICLE_ONLY_MODELS.computeIfAbsent(name, n -> ModelTemplates.PARTICLE_ONLY.create(finalName, new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)block)), this.vanillaGenerator.modelOutput()));
    }

    public void createSign(Block baseBlock, Block signBlock, Block wallSignBlock) {
        ResourceLocation particleLocation = this.particleOnlyModel(baseBlock);
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(signBlock, particleLocation));
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(wallSignBlock, particleLocation));
        this.vanillaGenerator.createSimpleFlatItemModel(signBlock.asItem());
        this.vanillaGenerator.skipAutoItemBlock(wallSignBlock);
    }

    public void createHangingSign(Block baseBlock, Block hangingSignBlock, Block wallHangingSignBlock) {
        ResourceLocation resourceLocation = this.particleOnlyModel(baseBlock);
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(hangingSignBlock, resourceLocation));
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(wallHangingSignBlock, resourceLocation));
        this.vanillaGenerator.createSimpleFlatItemModel(hangingSignBlock.asItem());
        this.vanillaGenerator.skipAutoItemBlock(wallHangingSignBlock);
    }

    public void createBarrel(Block barrelBlock) {
        ResourceLocation resourceLocation = TextureMapping.getBlockTexture((Block)barrelBlock, (String)"_top_open");
        this.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)barrelBlock).with(this.vanillaGenerator.createColumnWithFacing()).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.OPEN).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)TexturedModel.CUBE_TOP_BOTTOM.create(barrelBlock, this.vanillaGenerator.modelOutput()))).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)TexturedModel.CUBE_TOP_BOTTOM.get(barrelBlock).updateTextures(textureMapping -> textureMapping.put(TextureSlot.TOP, resourceLocation)).createWithSuffix(barrelBlock, "_open", this.vanillaGenerator.modelOutput())))));
    }

    public void createComposter(Block composterBlock) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)composterBlock, (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)composterBlock, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)composterBlock, (String)"_bottom"));
        ResourceLocation location = COMPOSTER_MODEL.create(composterBlock, mapping, this.vanillaGenerator.modelOutput());
        this.acceptBlockState((BlockStateGenerator)MultiPartGenerator.multiPart((Block)composterBlock).with(Variant.variant().with(VariantProperties.MODEL, (Object)location)).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(1)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents1"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(2)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents2"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(3)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents3"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(4)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents4"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(5)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents5"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(6)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents6"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(7)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents7"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(8)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER, (String)"_contents_ready"))));
    }

    public void createBlockTopSideBottom(Block bottomBlock, Block coverBlock, boolean withVariants) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)coverBlock, (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)coverBlock, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)bottomBlock));
        ResourceLocation location = ModelTemplates.CUBE_BOTTOM_TOP.create(coverBlock, mapping, this.vanillaGenerator.modelOutput());
        if (withVariants) {
            this.acceptBlockState((BlockStateGenerator)WoverBlockModelGenerators.randomTopModelVariant(coverBlock, location));
        } else {
            this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(coverBlock, location));
        }
    }

    public void createCubeModel(Block block) {
        TexturedModel model = TexturedModel.CUBE.get(block);
        TextureMapping mapping = this.getTextureModels(block, model).getMapping();
        ResourceLocation location = model.getTemplate().create(block, mapping, this.vanillaGenerator.modelOutput());
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(block, location));
    }

    public void createPressurePlate(Block plateBlock, ResourceLocation textureLocation) {
        this.createPressurePlate(plateBlock, new TextureMapping().put(TextureSlot.TEXTURE, textureLocation));
    }

    public void createPressurePlate(Block materialBlock, Block plateBlock) {
        this.createPressurePlate(plateBlock, this.getTextureModels(plateBlock, TexturedModel.CUBE.get(materialBlock)).getMapping());
    }

    private void createPressurePlate(Block plateBlock, TextureMapping mapping) {
        List<ResourceLocation> locations = Stream.of(ModelTemplates.PRESSURE_PLATE_UP, ModelTemplates.PRESSURE_PLATE_DOWN).map(template -> template.create(plateBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createPressurePlate(plateBlock, locations.get(0), locations.get(1)));
    }

    public void createButton(Block buttonBlock, ResourceLocation textureLocation) {
        this.createButton(buttonBlock, new TextureMapping().put(TextureSlot.TEXTURE, textureLocation));
    }

    public void createButton(Block materialBlock, Block buttonBlock) {
        this.createButton(buttonBlock, this.getTextureModels(buttonBlock, TexturedModel.CUBE.get(materialBlock)).getMapping());
    }

    private void createButton(Block buttonBlock, TextureMapping mapping) {
        List<ResourceLocation> locations = Stream.of(ModelTemplates.BUTTON, ModelTemplates.BUTTON_PRESSED).map(template -> template.create(buttonBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createButton(buttonBlock, locations.get(0), locations.get(1)));
        this.createItemModel(buttonBlock, ModelTemplates.BUTTON_INVENTORY, mapping);
    }

    public void createFence(Block fenceBlock, ResourceLocation textureLocation) {
        this.createFence(fenceBlock, new TextureMapping().put(TextureSlot.TEXTURE, textureLocation));
    }

    public void createFence(Block materialBlock, Block fenceBlock) {
        this.createFence(fenceBlock, this.getTextureModels(fenceBlock, TexturedModel.CUBE.get(materialBlock)).getMapping());
    }

    public void createFence(Block fenceBlock, TextureMapping mapping) {
        List<ResourceLocation> locations = Stream.of(ModelTemplates.FENCE_POST, ModelTemplates.FENCE_SIDE).map(template -> template.create(fenceBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createFence(fenceBlock, locations.get(0), locations.get(1)));
        this.createInventoryModel(fenceBlock, ModelTemplates.FENCE_INVENTORY, mapping);
    }

    public void createFenceGate(Block gateBlock, ResourceLocation textureLocation) {
        this.createFence(gateBlock, new TextureMapping().put(TextureSlot.TEXTURE, textureLocation));
    }

    public void createFenceGate(Block materialBlock, Block gateBlock) {
        this.createFenceGate(gateBlock, this.getTextureModels(gateBlock, TexturedModel.CUBE.get(materialBlock)).getMapping());
    }

    public void createFenceGate(Block gateBlock, TextureMapping mapping) {
        List<ResourceLocation> locations = Stream.of(ModelTemplates.FENCE_GATE_OPEN, ModelTemplates.FENCE_GATE_CLOSED, ModelTemplates.FENCE_GATE_WALL_OPEN, ModelTemplates.FENCE_GATE_WALL_CLOSED).map(template -> template.create(gateBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createFenceGate(gateBlock, locations.get(0), locations.get(1), locations.get(2), locations.get(3), true));
    }

    public void createStairs(Block stairBlock, ResourceLocation topTextureLocation, ResourceLocation sideTextureLocation, ResourceLocation bottomTextureLocation) {
        this.createStairs(stairBlock, new TextureMapping().put(TextureSlot.TOP, topTextureLocation).put(TextureSlot.SIDE, sideTextureLocation).put(TextureSlot.BOTTOM, bottomTextureLocation));
    }

    public void createStairs(Block materialBlock, Block stairBlock) {
        this.createStairs(stairBlock, this.getTextureModels(stairBlock, TexturedModel.CUBE.get(materialBlock)).getMapping());
    }

    public void createStairsWithModels(Block stairBlock, ResourceLocation stair, ResourceLocation outer, ResourceLocation inner) {
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createStairs(stairBlock, inner, stair, outer));
        this.delegateItemModel(stairBlock, stair);
    }

    public void createStairs(Block stairBlock, TextureMapping mapping) {
        List<ResourceLocation> locations = Stream.of(ModelTemplates.STAIRS_INNER, ModelTemplates.STAIRS_STRAIGHT, ModelTemplates.STAIRS_OUTER).map(template -> template.create(stairBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createStairs(stairBlock, locations.get(0), locations.get(1), locations.get(2)));
        this.delegateItemModel(stairBlock, locations.get(1));
    }

    public void createWall(Block materialBlock, Block wallBlock) {
        this.createWall(wallBlock, this.getTextureModels(wallBlock, TexturedModel.CUBE.get(materialBlock)).getMapping());
    }

    public void createWall(Block wallBlock, TextureMapping mapping) {
        List<ResourceLocation> locations = Stream.of(ModelTemplates.WALL_POST, ModelTemplates.WALL_LOW_SIDE, ModelTemplates.WALL_TALL_SIDE).map(template -> template.create(wallBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createWall(wallBlock, locations.get(0), locations.get(1), locations.get(2)));
        this.createInventoryModel(wallBlock, ModelTemplates.WALL_INVENTORY, mapping);
    }

    public void createSlab(Block slabBlock, Block baseBlock) {
        ResourceLocation res = TextureMapping.getBlockTexture((Block)baseBlock);
        this.createSlab(slabBlock, baseBlock, new TextureMapping().put(TextureSlot.SIDE, res).put(TextureSlot.BOTTOM, res).put(TextureSlot.TOP, res));
    }

    public void createSlab(Block slabBlock, Block baseBlock, TextureMapping mapping) {
        ResourceLocation fullBlockLocation = ModelLocationUtils.getModelLocation((Block)baseBlock);
        List<ResourceLocation> locations = Stream.of(ModelTemplates.SLAB_BOTTOM, ModelTemplates.SLAB_TOP).map(template -> template.create(slabBlock, mapping, this.vanillaGenerator.modelOutput())).toList();
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createSlab(slabBlock, locations.get(0), locations.get(1), fullBlockLocation));
        this.delegateItemModel(slabBlock, locations.get(0));
    }

    public void createRotatedPillar(Block pillarBlock) {
        ResourceLocation res = TextureMapping.getBlockTexture((Block)pillarBlock);
        this.createRotatedPillar(pillarBlock, new TextureMapping().put(TextureSlot.SIDE, res.withSuffix("_side")).put(TextureSlot.END, res.withSuffix("_top")));
    }

    public void createRotatedPillar(Block pillarBlock, TextureMapping mapping) {
        ResourceLocation model = ModelTemplates.CUBE_COLUMN.create(pillarBlock, mapping, this.vanillaGenerator.modelOutput());
        this.acceptBlockState(WoverBlockModelGeneratorsAccess.createAxisAlignedPillarBlock(pillarBlock, model));
    }

    private void createInventoryModel(Block wallBlock, ModelTemplate inventoryModel, TextureMapping mapping) {
        this.delegateItemModel(wallBlock, inventoryModel.create(wallBlock, mapping, this.vanillaGenerator.modelOutput()));
    }

    public void createChest(Block materialBlock, Block chestBlock) {
        ResourceLocation baseModel = this.particleOnlyModel(materialBlock);
        this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(chestBlock, baseModel));
    }

    public final void createItemModel(Block block, ModelTemplate template, TextureMapping mapping) {
        Item item = block.asItem();
        if (item != Items.AIR) {
            template.create(ModelLocationUtils.getModelLocation((Item)item), mapping, this.vanillaGenerator.modelOutput());
        }
        this.vanillaGenerator.skipAutoItemBlock(block);
    }

    public void createFlatItem(Block block) {
        this.vanillaGenerator.createSimpleFlatItemModel(block);
        this.vanillaGenerator.skipAutoItemBlock(block);
    }

    public void createWallItem(Block block, ResourceLocation textureLocation) {
        this.createInventoryModel(block, ModelTemplates.WALL_INVENTORY, new TextureMapping().put(TextureSlot.WALL, textureLocation));
        this.vanillaGenerator.skipAutoItemBlock(block);
    }

    public void createFlatItem(Block block, @Nullable ResourceLocation itemLocation) {
        if (itemLocation == null) {
            this.createFlatItem(block);
            return;
        }
        Item item = block.asItem();
        if (item != Items.AIR) {
            ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((ResourceLocation)itemLocation), this.vanillaGenerator.modelOutput());
        }
        this.vanillaGenerator.skipAutoItemBlock(block);
    }

    public static MultiVariantGenerator randomTopModelVariant(Block block, ResourceLocation model) {
        return MultiVariantGenerator.multiVariant((Block)block, (Variant[])new Variant[]{Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0).with(VariantProperties.UV_LOCK, (Object)false).with(VariantProperties.WEIGHT, (Object)1), Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.UV_LOCK, (Object)false).with(VariantProperties.WEIGHT, (Object)1), Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.UV_LOCK, (Object)false).with(VariantProperties.WEIGHT, (Object)1), Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.UV_LOCK, (Object)false).with(VariantProperties.WEIGHT, (Object)1)});
    }

    public BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput() {
        return this.vanillaGenerator.modelOutput();
    }

    public class Builder {
        private ResourceLocation fullBlockLocation;
        private final TexturedModel model;
        private final TextureMapping mapping;
        private final Map<ModelTemplate, ResourceLocation> models = Maps.newHashMap();

        private Builder(TexturedModel model, TextureMapping mapping) {
            this.model = model;
            this.mapping = mapping;
        }

        public Builder createFullBlock(Block fullBlock) {
            this.fullBlockLocation = this.model.getTemplate().create(fullBlock, this.mapping, WoverBlockModelGenerators.this.vanillaGenerator.modelOutput());
            WoverBlockModelGenerators.this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(fullBlock, this.fullBlockLocation));
            return this;
        }

        public Builder createDoor(Block doorBlock) {
            WoverBlockModelGenerators.this.vanillaGenerator.createDoor(doorBlock);
            return this;
        }

        public Builder createCustomFence(Block fenceBlock) {
            TextureMapping particles = TextureMapping.customParticle((Block)fenceBlock);
            List<ResourceLocation> locations = Stream.of(ModelTemplates.CUSTOM_FENCE_POST, ModelTemplates.CUSTOM_FENCE_SIDE_NORTH, ModelTemplates.CUSTOM_FENCE_SIDE_EAST, ModelTemplates.CUSTOM_FENCE_SIDE_SOUTH, ModelTemplates.CUSTOM_FENCE_SIDE_WEST).map(template -> template.create(fenceBlock, particles, WoverBlockModelGenerators.this.vanillaGenerator.modelOutput())).toList();
            WoverBlockModelGenerators.this.acceptBlockState(WoverBlockModelGeneratorsAccess.createCustomFence(fenceBlock, locations.get(0), locations.get(1), locations.get(2), locations.get(3), locations.get(4)));
            this.createInventoryModel(fenceBlock, ModelTemplates.CUSTOM_FENCE_INVENTORY, particles);
            return this;
        }

        public Builder createCustomFenceGate(Block gateBlock) {
            TextureMapping particles = TextureMapping.customParticle((Block)gateBlock);
            List<ResourceLocation> locations = Stream.of(ModelTemplates.CUSTOM_FENCE_GATE_OPEN, ModelTemplates.CUSTOM_FENCE_GATE_CLOSED, ModelTemplates.CUSTOM_FENCE_GATE_WALL_OPEN, ModelTemplates.CUSTOM_FENCE_GATE_WALL_CLOSED).map(template -> template.create(gateBlock, particles, WoverBlockModelGenerators.this.vanillaGenerator.modelOutput())).toList();
            WoverBlockModelGenerators.this.acceptBlockState(WoverBlockModelGeneratorsAccess.createFenceGate(gateBlock, locations.get(0), locations.get(1), locations.get(2), locations.get(3), false));
            return this;
        }

        private Builder createFullBlockVariant(Block block) {
            TexturedModel texturedModel = WoverBlockModelGenerators.this.getTextureModels(block, TexturedModel.CUBE.get(block));
            ResourceLocation resourceLocation = texturedModel.create(block, WoverBlockModelGenerators.this.vanillaGenerator.modelOutput());
            WoverBlockModelGenerators.this.acceptBlockState((BlockStateGenerator)WoverBlockModelGeneratorsAccess.createSimpleBlock(block, resourceLocation));
            return this;
        }

        private void createTrapdoor(Block block, boolean hasOrientation) {
            if (!hasOrientation) {
                WoverBlockModelGenerators.this.vanillaGenerator.createTrapdoor(block);
            } else {
                WoverBlockModelGenerators.this.vanillaGenerator.createOrientableTrapdoor(block);
            }
        }

        public Builder createSlab(Block slabBlock) {
            if (this.fullBlockLocation == null) {
                throw new IllegalStateException("Please call createFullBlock before calling createSlab");
            }
            List<ResourceLocation> locations = Stream.of(ModelTemplates.SLAB_BOTTOM, ModelTemplates.SLAB_TOP).map(template -> this.computeModelIfAbsent((ModelTemplate)template, slabBlock)).toList();
            WoverBlockModelGenerators.this.acceptBlockState(WoverBlockModelGeneratorsAccess.createSlab(slabBlock, locations.get(0), locations.get(1), this.fullBlockLocation));
            WoverBlockModelGenerators.this.delegateItemModel(slabBlock, locations.get(0));
            return this;
        }

        private ResourceLocation computeModelIfAbsent(ModelTemplate modelTemplate, Block block) {
            return this.models.computeIfAbsent(modelTemplate, m -> m.create(block, this.mapping, WoverBlockModelGenerators.this.vanillaGenerator.modelOutput()));
        }

        private void createInventoryModel(Block wallBlock, ModelTemplate inventoryModel, TextureMapping mapping) {
            WoverBlockModelGenerators.this.delegateItemModel(wallBlock, inventoryModel.create(wallBlock, mapping, WoverBlockModelGenerators.this.vanillaGenerator.modelOutput()));
        }
    }
}

