/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import org.betterx.wover.block.impl.predicate.BlockPredicatesImpl;
import org.jetbrains.annotations.NotNull;

public class IsFullShape
implements BlockPredicate {
    public static final IsFullShape HERE = new IsFullShape();
    public static final MapCodec<IsFullShape> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(p -> p.offset)).apply((Applicative)instance, IsFullShape::new));
    protected final Vec3i offset;

    private IsFullShape() {
        this(Vec3i.ZERO);
    }

    public IsFullShape(Vec3i offset) {
        this.offset = offset;
    }

    @NotNull
    public BlockPredicateType<IsFullShape> type() {
        return BlockPredicatesImpl.FULL_SHAPE;
    }

    public boolean test(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        BlockState state = worldGenLevel.getBlockState(blockPos.offset(this.offset));
        return state.isCollisionShapeFullBlock((BlockGetter)worldGenLevel, blockPos);
    }
}

