/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import org.betterx.wover.complex.api.equipment.ArmorTier;

public enum ArmorSlot {
    HELMET_SLOT(0, "helmet", ArmorItem.Type.HELMET, RecipeCategory.COMBAT),
    CHESTPLATE_SLOT(1, "chestplate", ArmorItem.Type.CHESTPLATE, RecipeCategory.COMBAT),
    LEGGINGS_SLOT(2, "leggings", ArmorItem.Type.LEGGINGS, RecipeCategory.COMBAT),
    BOOTS_SLOT(3, "boots", ArmorItem.Type.BOOTS, RecipeCategory.COMBAT);

    public final RecipeCategory category;
    public final String name;
    public final int slotIndex;
    public final ArmorItem.Type armorType;
    private final PropertiesBuilder propertiesBuilder;

    private ArmorSlot(int slotIndex, String name, ArmorItem.Type armorType, RecipeCategory category) {
        this.name = name;
        this.category = category;
        this.slotIndex = slotIndex;
        this.armorType = armorType;
        this.propertiesBuilder = (slot, material) -> {
            ArmorTier.ArmorValues values = material.getValues(slot);
            if (values == null) {
                throw new IllegalArgumentException("No values for slot " + String.valueOf((Object)slot) + " in tier " + String.valueOf(material));
            }
            return new Item.Properties().durability(slot.armorType.getDurability(values.durability()));
        };
    }

    public Item.Properties buildProperties(ArmorTier tier) {
        return this.propertiesBuilder.build(this, tier);
    }

    public static interface PropertiesBuilder {
        public Item.Properties build(ArmorSlot var1, ArmorTier var2);
    }
}

