/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import com.mojang.serialization.Lifecycle;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverRegistryProvider;
import org.jetbrains.annotations.ApiStatus;

public abstract class WoverRegistryContentProvider<T>
extends WoverRegistryProvider<T> {
    private final List<ResourceKey<T>> content = new LinkedList<ResourceKey<T>>();

    public WoverRegistryContentProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey) {
        super(modCore, title, registryKey);
    }

    @Override
    protected abstract void bootstrap(BootstrapContext<T> var1);

    private void addContent(ResourceKey<T> resourceKey) {
        this.content.add(resourceKey);
    }

    private void wrappedBoostrap(final BootstrapContext<T> context) {
        BootstrapContext wrapped = new BootstrapContext<T>(){

            public Holder.Reference<T> register(ResourceKey<T> resourceKey, T object, Lifecycle lifecycle) {
                WoverRegistryContentProvider.this.addContent(resourceKey);
                return context.register(resourceKey, object, lifecycle);
            }

            public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> resourceKey) {
                return context.lookup(resourceKey);
            }
        };
        this.bootstrap(wrapped);
    }

    @Override
    @ApiStatus.Internal
    public final void buildRegistry(RegistrySetBuilder registryBuilder) {
        this.modCore.log.info("Registering " + this.title);
        registryBuilder.add(this.registryKey, this::wrappedBoostrap);
    }

    @Override
    @ApiStatus.Internal
    public final DataProvider getProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, ExistingFileHelper existingFileHelper) {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        this.buildRegistry(registryBuilder);
        return new DatapackBuiltinEntriesProvider(output, registriesFuture, registryBuilder, this.modIdSet());
    }
}

