/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.events.impl;

import java.util.Objects;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.util.SortedLinkedList;

public class AbstractEvent<T extends org.betterx.wover.events.api.Subscriber>
implements Event<T> {
    public static final int SYSTEM_PRIORITY = 100000000;
    protected final String eventName;
    protected final SortedLinkedList<Subscriber<T>> handlers;

    public AbstractEvent(String eventName) {
        this.eventName = eventName;
        this.handlers = new SortedLinkedList((a, b) -> b.priority - a.priority);
    }

    @Override
    public final boolean subscribe(T handler) {
        return this.subscribe(handler, 1000);
    }

    public final boolean _subscribe(T handler, int priority) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(new Subscriber<T>(handler, priority));
            return true;
        }
        return false;
    }

    @Override
    public final boolean subscribe(T handler, int priority) {
        return this._subscribe(handler, Math.abs(priority));
    }

    @Override
    public final boolean subscribeReadOnly(T handler, int priority) {
        return this._subscribe(handler, -10000 + priority);
    }

    protected static class Subscriber<T extends org.betterx.wover.events.api.Subscriber> {
        public final T task;
        private final int priority;

        public Subscriber(T task, int priority) {
            this.task = task;
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Subscriber) {
                Subscriber that = (Subscriber)o;
                return Objects.equals(this.task, that.task);
            }
            if (o != null) {
                return o.equals(this.task);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.task);
        }

        public String toString() {
            return this.task.toString() + " - " + this.priority;
        }
    }
}

