/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.wover.feature.api.features.config.PlaceBlockFeatureConfig;

public class PlaceFacingBlockConfig
extends PlaceBlockFeatureConfig {
    public static final Codec<PlaceFacingBlockConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(PlaceFacingBlockConfig.blockStateCodec(), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("dir").orElse(List.of(Direction.NORTH)).forGetter(a -> a.directions)).apply((Applicative)instance, PlaceFacingBlockConfig::new));
    private final List<Direction> directions;

    public PlaceFacingBlockConfig(Block block, List<Direction> dir) {
        this(block.defaultBlockState(), dir);
    }

    public PlaceFacingBlockConfig(BlockState state, List<Direction> dir) {
        this((BlockStateProvider)BlockStateProvider.simple((BlockState)state), dir);
    }

    public PlaceFacingBlockConfig(List<BlockState> states, List<Direction> dir) {
        this(PlaceFacingBlockConfig.buildWeightedList(states), dir);
    }

    public PlaceFacingBlockConfig(SimpleWeightedRandomList<BlockState> blocks, List<Direction> dir) {
        this((BlockStateProvider)new WeightedStateProvider(blocks), dir);
    }

    public PlaceFacingBlockConfig(BlockStateProvider provider, List<Direction> dir) {
        super(provider);
        this.directions = dir;
    }

    @Override
    public boolean placeBlock(FeaturePlaceContext<? extends PlaceBlockFeatureConfig> ctx, WorldGenLevel level, BlockPos pos, BlockState targetState) {
        for (Direction dir : this.directions) {
            BlockPos testPos = pos.relative(dir);
            BlockState lookupState = (BlockState)targetState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)dir);
            if (!level.getBlockState(testPos).isAir() || !lookupState.canSurvive((LevelReader)level, testPos)) continue;
            lookupState.canSurvive((LevelReader)level, testPos);
            level.setBlock(testPos, lookupState, 18);
            return true;
        }
        return false;
    }
}

