/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;

public class Extend
extends PlacementModifier {
    public static final MapCodec<Extend> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Direction.CODEC.fieldOf("direction").orElse((Object)Direction.DOWN).forGetter(cfg -> cfg.direction), (App)IntProvider.codec((int)0, (int)16).fieldOf("length").orElse((Object)UniformInt.of((int)0, (int)3)).forGetter(cfg -> cfg.length)).apply((Applicative)instance, Extend::new));
    private final Direction direction;
    private final IntProvider length;

    public Extend(Direction direction, IntProvider length) {
        this.direction = direction;
        this.length = length;
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        Stream.Builder<BlockPos> builder = Stream.builder();
        int count = this.length.sample(random);
        builder.add(blockPos);
        for (int y = 1; y < count + 1; ++y) {
            builder.add(blockPos.relative(this.direction, y));
        }
        return builder.build();
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifiersImpl.EXTEND;
    }
}

