/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.BlockColumnFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.AsBlockColumn;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsBlockColumnImpl
extends FeatureConfiguratorImpl<BlockColumnConfiguration, BlockColumnFeature>
implements AsBlockColumn {
    private final List<BlockColumnConfiguration.Layer> layers = new LinkedList<BlockColumnConfiguration.Layer>();
    private Direction direction = Direction.UP;
    private BlockPredicate allowedPlacement = BlockPredicate.ONLY_IN_AIR_PREDICATE;
    private boolean prioritizeTip = false;

    AsBlockColumnImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public AsBlockColumn add(int height, Block block) {
        return this.add((IntProvider)ConstantInt.of((int)height), (BlockStateProvider)BlockStateProvider.simple((Block)block));
    }

    @Override
    public AsBlockColumn add(int height, BlockState state) {
        return this.add((IntProvider)ConstantInt.of((int)height), (BlockStateProvider)BlockStateProvider.simple((BlockState)state));
    }

    @Override
    public AsBlockColumn add(int height, BlockStateProvider state) {
        return this.add((IntProvider)ConstantInt.of((int)height), state);
    }

    @Override
    public final AsBlockColumn addRandom(int height, BlockState ... states) {
        return this.addRandom((IntProvider)ConstantInt.of((int)height), states);
    }

    @Override
    public final AsBlockColumn addRandom(IntProvider height, BlockState ... states) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (BlockState state : states) {
            builder.add((Object)state, 1);
        }
        return this.add(height, (BlockStateProvider)new WeightedStateProvider(builder.build()));
    }

    @Override
    public AsBlockColumn add(IntProvider height, Block block) {
        return this.add(height, (BlockStateProvider)BlockStateProvider.simple((Block)block));
    }

    @Override
    public AsBlockColumn add(IntProvider height, BlockState state) {
        return this.add(height, (BlockStateProvider)BlockStateProvider.simple((BlockState)state));
    }

    @Override
    public AsBlockColumn add(IntProvider height, BlockStateProvider state) {
        this.layers.add(new BlockColumnConfiguration.Layer(height, state));
        return this;
    }

    @Override
    public AsBlockColumn addTripleShape(BlockState state, IntProvider midHeight) {
        return this.add(1, (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM))).add(midHeight, (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE))).add(1, (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
    }

    @Override
    public AsBlockColumn addTripleShapeUpsideDown(BlockState state, IntProvider midHeight) {
        return this.add(1, (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).add(midHeight, (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE))).add(1, (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    @Override
    public AsBlockColumn addBottomShapeUpsideDown(BlockState state, IntProvider midHeight) {
        return this.add(midHeight, (BlockState)state.setValue((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(false))).add(1, (BlockState)state.setValue((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public AsBlockColumn addBottomShape(BlockState state, IntProvider midHeight) {
        return this.add(1, (BlockState)state.setValue((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(true))).add(midHeight, (BlockState)state.setValue((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AsBlockColumn addTopShapeUpsideDown(BlockState state, IntProvider midHeight) {
        return this.add(1, (BlockState)state.setValue((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(true))).add(midHeight, (BlockState)state.setValue((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AsBlockColumn addTopShape(BlockState state, IntProvider midHeight) {
        return this.add(midHeight, (BlockState)state.setValue((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(false))).add(1, (BlockState)state.setValue((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public AsBlockColumn direction(Direction dir) {
        this.direction = dir;
        return this;
    }

    @Override
    public AsBlockColumn prioritizeTip() {
        return this.prioritizeTip(true);
    }

    @Override
    public AsBlockColumn prioritizeTip(boolean prio) {
        this.prioritizeTip = prio;
        return this;
    }

    @Override
    public AsBlockColumn allowedPlacement(BlockPredicate predicate) {
        this.allowedPlacement = predicate;
        return this;
    }

    @Override
    public BlockColumnConfiguration createConfiguration() {
        return new BlockColumnConfiguration(this.layers, this.direction, this.allowedPlacement, this.prioritizeTip);
    }

    @Override
    @NotNull
    protected BlockColumnFeature getFeature() {
        return (BlockColumnFeature)Feature.BLOCK_COLUMN;
    }

    public static class Key
    extends ConfiguredFeatureKey<AsBlockColumn> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public AsBlockColumn bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new AsBlockColumnImpl(ctx, this.key);
        }
    }
}

