/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.betterx.wover.feature.api.Features;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.AsPillar;
import org.betterx.wover.feature.api.features.PillarFeature;
import org.betterx.wover.feature.api.features.config.PillarFeatureConfig;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsPillarImpl
extends FeatureConfiguratorImpl<PillarFeatureConfig, PillarFeature>
implements AsPillar {
    private IntProvider maxHeight;
    private IntProvider minHeight;
    private BlockStateProvider stateProvider;
    private PillarFeatureConfig.KnownTransformers transformer;
    private Direction direction = Direction.UP;
    private BlockPredicate allowedPlacement = BlockPredicate.ONLY_IN_AIR_PREDICATE;

    AsPillarImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public AsPillar allowedPlacement(BlockPredicate predicate) {
        this.allowedPlacement = predicate;
        return this;
    }

    @Override
    public AsPillar transformer(@NotNull PillarFeatureConfig.KnownTransformers transformer) {
        this.transformer = transformer;
        return this;
    }

    @Override
    public AsPillar direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public AsPillar blockState(Block block) {
        return this.blockState((BlockStateProvider)BlockStateProvider.simple((BlockState)block.defaultBlockState()));
    }

    @Override
    public AsPillar blockState(BlockState state) {
        return this.blockState((BlockStateProvider)BlockStateProvider.simple((BlockState)state));
    }

    @Override
    public AsPillar blockState(BlockStateProvider provider) {
        this.stateProvider = provider;
        return this;
    }

    @Override
    public AsPillar maxHeight(int max) {
        this.maxHeight = ConstantInt.of((int)max);
        return this;
    }

    @Override
    public AsPillar maxHeight(IntProvider max) {
        this.maxHeight = max;
        return this;
    }

    @Override
    public AsPillar minHeight(int min) {
        this.minHeight = ConstantInt.of((int)min);
        return this;
    }

    @Override
    public AsPillar minHeight(IntProvider min) {
        this.minHeight = min;
        return this;
    }

    @Override
    @NotNull
    public PillarFeatureConfig createConfiguration() {
        if (this.transformer == null) {
            this.throwStateError("A Pillar Feature needs a transformer");
        }
        if (this.stateProvider == null) {
            this.throwStateError("A Pillar Feature needs a stateProvider");
        }
        if (this.maxHeight == null) {
            this.throwStateError("A Pillar Feature needs a height");
        }
        if (this.minHeight == null) {
            this.minHeight = ConstantInt.of((int)0);
        }
        return new PillarFeatureConfig(this.minHeight, this.maxHeight, this.direction, this.allowedPlacement, this.stateProvider, this.transformer);
    }

    @Override
    @NotNull
    protected PillarFeature getFeature() {
        return (PillarFeature)Features.PILLAR;
    }

    public static class Key
    extends ConfiguredFeatureKey<AsPillar> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public AsPillar bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new AsPillarImpl(ctx, this.key);
        }
    }
}

