/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource.end;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.wover.biome.impl.data.BiomeDataRegistryImpl;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithConfig;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.generator.api.biomesource.WoverBiomeSource;
import org.betterx.wover.generator.api.biomesource.end.BiomeDecider;
import org.betterx.wover.generator.api.biomesource.end.WoverEndConfig;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceConfigPanel;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceWithConfigScreen;
import org.betterx.wover.generator.api.map.BiomeMap;
import org.betterx.wover.generator.impl.biomesource.end.BiomeDeciderImpl;
import org.betterx.wover.generator.impl.client.EndConfigPage;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.NotNull;

public class WoverEndBiomeSource
extends WoverBiomeSource
implements BiomeSourceWithConfig<WoverEndBiomeSource, WoverEndConfig>,
BiomeSourceWithConfigScreen<WoverEndBiomeSource, WoverEndConfig> {
    public static MapCodec<WoverEndBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)WoverEndConfig.CODEC.fieldOf("config").orElse((Object)WoverEndConfig.DEFAULT).forGetter(o -> o.config)).apply((Applicative)instance, instance.stable(WoverEndBiomeSource::new)));
    public static final List<TagKey<Biome>> TAGS = List.of(CommonBiomeTags.IS_END_CENTER, CommonBiomeTags.IS_END_BARRENS, CommonBiomeTags.IS_SMALL_END_ISLAND, CommonBiomeTags.IS_END_HIGHLAND, CommonBiomeTags.IS_END_MIDLAND, BiomeTags.IS_END);
    private final Point pos;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private BiomeMap mapCenter;
    private BiomeMap mapBarrens;
    private WoverBiomePicker endLandBiomePicker;
    private WoverBiomePicker endVoidBiomePicker;
    private WoverBiomePicker endCenterBiomePicker;
    private WoverBiomePicker endBarrensBiomePicker;
    private List<BiomeDecider> deciders;
    private WoverEndConfig config;

    private WoverEndBiomeSource(long seed, WoverEndConfig config) {
        this(seed, config, true);
    }

    public WoverEndBiomeSource(WoverEndConfig config) {
        this(0L, config, false);
    }

    private WoverEndBiomeSource(long seed, WoverEndConfig config, boolean initMaps) {
        super(seed);
        this.config = config;
        this.rebuildBiomes(false);
        this.pos = new Point();
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @Override
    protected List<WoverBiomeSource.TagToPicker> createFreshPickerMap() {
        this.deciders = BiomeDeciderImpl.DECIDERS.stream().filter(d -> d.canProvideFor(this)).map(d -> d.createInstance(this)).toList();
        this.endLandBiomePicker = new WoverBiomePicker(this.fallbackBiome());
        this.endVoidBiomePicker = new WoverBiomePicker((ResourceKey<Biome>)Biomes.SMALL_END_ISLANDS);
        this.endCenterBiomePicker = new WoverBiomePicker((ResourceKey<Biome>)Biomes.THE_END);
        this.endBarrensBiomePicker = new WoverBiomePicker((ResourceKey<Biome>)Biomes.END_BARRENS);
        return List.of(new WoverBiomeSource.TagToPicker(CommonBiomeTags.IS_END_CENTER, this.endCenterBiomePicker), new WoverBiomeSource.TagToPicker(CommonBiomeTags.IS_END_BARRENS, this.endBarrensBiomePicker), new WoverBiomeSource.TagToPicker(CommonBiomeTags.IS_SMALL_END_ISLAND, this.endVoidBiomePicker), new WoverBiomeSource.TagToPicker(CommonBiomeTags.IS_END_HIGHLAND, this.endLandBiomePicker), new WoverBiomeSource.TagToPicker(CommonBiomeTags.IS_END_MIDLAND, this.endLandBiomePicker), new WoverBiomeSource.TagToPicker((TagKey<Biome>)BiomeTags.IS_END, this.endLandBiomePicker));
    }

    @Override
    protected TagKey<Biome> defaultBiomeTag() {
        return CommonBiomeTags.IS_END_HIGHLAND;
    }

    @Override
    protected List<TagKey<Biome>> acceptedTags() {
        return TAGS;
    }

    @Override
    protected ResourceKey<Biome> fallbackBiome() {
        return Biomes.END_HIGHLANDS;
    }

    @Override
    public String toShortString() {
        return "WoVer - The End  BiomeSource (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public String toString() {
        return this.toShortString() + "\n    biomes     = " + this.possibleBiomes().size() + "\n    namespaces = " + this.getNamespaces() + "\n    seed       = " + this.currentSeed + "\n    height     = " + this.maxHeight + "\n    deciders   = " + this.deciders.size() + "\n    config     = " + String.valueOf(this.config);
    }

    @Override
    protected void onInitMap(long newSeed) {
        for (BiomeDecider decider : this.deciders) {
            decider.createMap((picker, size) -> this.config.mapVersion.mapBuilder.create(newSeed, size <= 0 ? this.config.landBiomesSize : size, picker));
        }
        this.mapLand = this.config.mapVersion.mapBuilder.create(newSeed, this.config.landBiomesSize, this.endLandBiomePicker);
        this.mapVoid = this.config.mapVersion.mapBuilder.create(newSeed, this.config.voidBiomesSize, this.endVoidBiomePicker);
        this.mapCenter = this.config.mapVersion.mapBuilder.create(newSeed, this.config.centerBiomesSize, this.endCenterBiomePicker);
        this.mapBarrens = this.config.mapVersion.mapBuilder.create(newSeed, this.config.barrensBiomesSize, this.endBarrensBiomePicker);
    }

    @Override
    protected void onHeightChange(int newHeight) {
    }

    @Override
    protected void onFinishBiomeRebuild(List<WoverBiomeSource.TagToPicker> pickerMap) {
        super.onFinishBiomeRebuild(pickerMap);
        for (BiomeDecider decider : this.deciders) {
            decider.rebuild();
        }
        if (this.endVoidBiomePicker.isEmpty()) {
            if (!ModCore.isDatagen() && WorldState.allStageRegistryAccess() != null) {
                LibWoverWorldGenerator.C.log.verbose("No Void Biomes found. Disabling by using barrens");
            }
            this.endVoidBiomePicker = this.endBarrensBiomePicker;
        }
        if (this.endBarrensBiomePicker.isEmpty()) {
            if (!ModCore.isDatagen() && WorldState.allStageRegistryAccess() != null) {
                LibWoverWorldGenerator.C.log.verbose("No Barrens Biomes found. Disabling by using land Biomes");
            }
            this.endBarrensBiomePicker = this.endLandBiomePicker;
            this.endVoidBiomePicker = this.endLandBiomePicker;
        }
        if (this.endCenterBiomePicker.isEmpty()) {
            if (!ModCore.isDatagen() && WorldState.allStageRegistryAccess() != null) {
                LibWoverWorldGenerator.C.log.verbose("No Center Island Biomes found. Forcing use of vanilla center.");
            }
            this.endCenterBiomePicker.addBiome(BiomeDataRegistryImpl.getFromRegistryOrTemp((ResourceKey<Biome>)Biomes.THE_END));
            this.endCenterBiomePicker.rebuild();
            if (this.endCenterBiomePicker.isEmpty()) {
                if (!ModCore.isDatagen() && WorldState.allStageRegistryAccess() != null) {
                    LibWoverWorldGenerator.C.log.verbose("Unable to force vanilla central Island. Falling back to land Biomes...");
                }
                this.endCenterBiomePicker = this.endLandBiomePicker;
            }
        }
    }

    @NotNull
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @NotNull
    public Holder<Biome> getNoiseBiome(int biomeX, int biomeY, int biomeZ, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Climate.Sampler sampler) {
        long dist;
        if (!this.wasBound()) {
            this.reloadBiomes(false);
        }
        if (this.mapLand == null || this.mapVoid == null || this.mapCenter == null || this.mapBarrens == null) {
            return (Holder)this.possibleBiomes().stream().findFirst().orElseThrow();
        }
        int posX = QuartPos.toBlock((int)biomeX);
        int posY = QuartPos.toBlock((int)biomeY);
        int posZ = QuartPos.toBlock((int)biomeZ);
        long l = dist = (long)(Math.abs(posX) + Math.abs(posZ)) > (long)this.config.innerVoidRadiusSquared ? (long)this.config.innerVoidRadiusSquared + 1L : (long)posX * (long)posX + (long)posZ * (long)posZ;
        if ((biomeX & 0x3F) == 0 || (biomeZ & 0x3F) == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
            this.mapCenter.clearCache();
            this.mapVoid.clearCache();
            for (BiomeDecider decider : this.deciders) {
                decider.clearMapCache();
            }
        }
        int x = (SectionPos.blockToSectionCoord((int)posX) * 2 + 1) * 8;
        int z = (SectionPos.blockToSectionCoord((int)posZ) * 2 + 1) * 8;
        double d = sampler.erosion().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, posY, z));
        TagKey<Biome> suggestedType = dist <= (long)this.config.innerVoidRadiusSquared ? CommonBiomeTags.IS_END_CENTER : (d > 0.25 ? CommonBiomeTags.IS_END_HIGHLAND : (d >= -0.0625 ? CommonBiomeTags.IS_END_MIDLAND : (d < -0.21875 ? CommonBiomeTags.IS_SMALL_END_ISLAND : (this.config.withVoidBiomes ? CommonBiomeTags.IS_END_BARRENS : CommonBiomeTags.IS_END_HIGHLAND))));
        TagKey<Biome> originalType = suggestedType;
        for (BiomeDecider decider : this.deciders) {
            suggestedType = decider.suggestType(originalType, suggestedType, d, this.maxHeight, posX, posY, posZ, biomeX, biomeY, biomeZ);
        }
        for (BiomeDecider decider : this.deciders) {
            WoverBiomePicker.PickableBiome result;
            if (!decider.canProvideBiome(suggestedType) || (result = decider.provideBiome(suggestedType, posX, posY, posZ)) == null) continue;
            return result.biome;
        }
        if (suggestedType == CommonBiomeTags.IS_END_CENTER) {
            return this.mapCenter.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        if (suggestedType == CommonBiomeTags.IS_SMALL_END_ISLAND) {
            return this.mapVoid.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        if (suggestedType == CommonBiomeTags.IS_END_BARRENS) {
            return this.mapBarrens.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        return this.mapLand.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
    }

    @Override
    public WoverEndConfig getBiomeSourceConfig() {
        return this.config;
    }

    @Override
    public void setBiomeSourceConfig(WoverEndConfig newConfig) {
        this.config = newConfig;
        this.rebuildBiomes(true);
        this.initMap(this.currentSeed);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BiomeSourceConfigPanel<WoverEndBiomeSource, WoverEndConfig> biomeSourceConfigPanel(@NotNull Screen parent) {
        return new EndConfigPage(this.config);
    }
}

