/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.betterx.wover.common.generator.api.chunkgenerator.RestorableBiomeSource;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.generator.impl.chunkgenerator.BiomeRepairHelper;
import org.betterx.wover.generator.impl.chunkgenerator.ChunkGeneratorManagerImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WorldGeneratorConfigImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGenerator;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;

public class WoverChunkGeneratorImpl {
    public static final ResourceKey<NoiseGeneratorSettings> LEGACY_AMPLIFIED_NETHER = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)LegacyHelper.BCLIB_CORE.convertNamespace(WoverChunkGenerator.AMPLIFIED_NETHER.location()));

    @ApiStatus.Internal
    public static void initialize() {
        WorldLifecycle.MINECRAFT_SERVER_READY.subscribe(WoverChunkGeneratorImpl::restoreInitialBiomeSourceInAllDimensions);
        WorldLifecycle.ON_DIMENSION_LOAD.subscribe(WoverChunkGeneratorImpl::repairBiomeSourceInAllDimensions);
        WorldLifecycle.BEFORE_CREATING_LEVELS.subscribe(WoverChunkGeneratorImpl::printInfo, -1000);
    }

    private static void printInfo(LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, LayeredRegistryAccess<RegistryLayer> registryLayerLayeredRegistryAccess, WorldData worldData) {
        if (WorldState.registryAccess() != null) {
            Registry dimensionsRegistry = WorldState.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
            ChunkGeneratorManagerImpl.printDimensionInfo((Registry<LevelStem>)dimensionsRegistry);
        }
    }

    private static void restoreInitialBiomeSourceInAllDimensions(LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, WorldStem worldStem) {
        for (Map.Entry entry : WorldState.registryAccess().registryOrThrow(Registries.LEVEL_STEM).entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            ChunkGenerator chunkGenerator = stem.generator();
            if (!(chunkGenerator instanceof RestorableBiomeSource)) continue;
            RestorableBiomeSource generator = (RestorableBiomeSource)chunkGenerator;
            generator.restoreInitialBiomeSource((ResourceKey<LevelStem>)key);
        }
    }

    private static LayeredRegistryAccess<RegistryLayer> repairBiomeSourceInAllDimensions(LayeredRegistryAccess<RegistryLayer> registries) {
        WorldGeneratorConfigImpl.migrateGeneratorSettings();
        RegistryAccess.Frozen access = registries.compositeAccess();
        Registry dimensions = access.registryOrThrow(Registries.LEVEL_STEM);
        BiomeRepairHelper biomeHelper = new BiomeRepairHelper();
        Registry<LevelStem> changedDimensions = biomeHelper.repairBiomeSourceInAllDimensions((RegistryAccess)access, (Registry<LevelStem>)dimensions);
        if (dimensions != changedDimensions) {
            LibWoverWorldGenerator.C.log.verbose("Loading World with initially configured Dimensions.");
            registries = registries.replaceFrom((Object)RegistryLayer.DIMENSIONS, new RegistryAccess.Frozen[]{new RegistryAccess.ImmutableRegistryAccess(List.of(changedDimensions)).freeze()});
        }
        return registries;
    }

    public static Registry<LevelStem> replaceGenerator(ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey, RegistryAccess registryAccess, Set<Map.Entry<ResourceKey<LevelStem>, LevelStem>> dimensionRegistry, ChunkGenerator generator, StemGetter getter, RegisterHelper registerHelper) {
        Registry dimensionTypeRegistry = registryAccess.registryOrThrow(Registries.DIMENSION_TYPE);
        LevelStem levelStem = getter.get(dimensionKey);
        Holder dimensionType = levelStem == null ? dimensionTypeRegistry.getHolderOrThrow(dimensionTypeKey) : levelStem.type();
        MappedRegistry writableRegistry = new MappedRegistry(Registries.LEVEL_STEM, Lifecycle.experimental());
        writableRegistry.register(dimensionKey, (Object)new LevelStem(dimensionType, generator), RegistrationInfo.BUILT_IN);
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : dimensionRegistry) {
            ResourceKey<LevelStem> resourceKey = entry.getKey();
            if (dimensionKey.location().equals((Object)resourceKey.location())) continue;
            registerHelper.register((MappedRegistry<LevelStem>)writableRegistry, resourceKey, entry.getValue());
        }
        return writableRegistry;
    }

    public static interface StemGetter {
        public LevelStem get(ResourceKey<LevelStem> var1);
    }

    public static interface RegisterHelper {
        public Holder.Reference<LevelStem> register(MappedRegistry<LevelStem> var1, ResourceKey<LevelStem> var2, LevelStem var3);
    }
}

