/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.client;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.Button;
import de.ambertation.wunderlib.ui.layout.components.DropDown;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Tabs;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalScroll;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreen;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceConfigPanel;
import org.betterx.wover.generator.api.client.biomesource.client.BiomeSourceWithConfigScreen;
import org.betterx.wover.generator.impl.chunkgenerator.ChunkGeneratorManagerImpl;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGeneratorImpl;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.WorldPresetTags;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.ui.impl.client.WelcomeScreen;
import org.betterx.wover.ui.impl.client.WoverLayoutScreen;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WorldSetupScreen
extends LayoutScreen
implements BiomeSourceConfigPanel.DimensionUpdater {
    private final List<ResourceKey<DimensionType>> sortedDimensions = List.of(BuiltinDimensionTypes.NETHER, BuiltinDimensionTypes.END, BuiltinDimensionTypes.OVERWORLD);
    private final Map<ResourceKey<DimensionType>, DimensionContent> dimensions = Map.of(BuiltinDimensionTypes.NETHER, new DimensionContent((ResourceKey<LevelStem>)LevelStem.NETHER, (ResourceKey<DimensionType>)BuiltinDimensionTypes.NETHER), BuiltinDimensionTypes.END, new DimensionContent((ResourceKey<LevelStem>)LevelStem.END, (ResourceKey<DimensionType>)BuiltinDimensionTypes.END), BuiltinDimensionTypes.OVERWORLD, new DimensionContent((ResourceKey<LevelStem>)LevelStem.OVERWORLD, (ResourceKey<DimensionType>)BuiltinDimensionTypes.OVERWORLD));
    private final WorldCreationContext context;
    private final VerticalStack contentFallback;
    private final CreateWorldScreen createWorldScreen;
    private Tabs mainTabs;
    Button netherButton;
    Button endButton;
    VerticalScroll<?> scroller;
    HorizontalStack title;

    public WorldSetupScreen(@Nullable CreateWorldScreen parent, WorldCreationContext context) {
        super((Screen)parent, (Component)Component.translatable((String)"title.screen.wover.worldgen.main"), 2, 6, 10);
        this.context = context;
        this.createWorldScreen = parent;
        this.contentFallback = (VerticalStack)new VerticalStack(WorldSetupScreen.fit(), WorldSetupScreen.fit()).centerHorizontal();
        this.contentFallback.addSpacer(16);
        ((Text)this.contentFallback.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (Component)Component.translatable((String)"title.screen.wover.worldgen.no_generator_config")).centerVertical()).setColor(ColorHelper.DARK_GRAY);
    }

    private void generatorChanged(DimensionContent content, DimensionValue selected) {
        if (content.stack != null) {
            int selectedPage = this.mainTabs == null ? 0 : this.mainTabs.getSelectedPage();
            BiomeSource selectedBiomeSource = selected.dimension.generator().getBiomeSource();
            if (selectedBiomeSource instanceof BiomeSourceWithConfigScreen) {
                BiomeSourceWithConfigScreen bs = (BiomeSourceWithConfigScreen)selectedBiomeSource;
                content.configPanel = bs.biomeSourceConfigPanel((Screen)this);
                content.stack.replaceOrAdd(content.stackIndex, content.configPanel.getPanel());
            } else {
                content.configPanel = null;
                content.stack.replaceOrAdd(content.stackIndex, (LayoutComponent)this.contentFallback);
            }
            if (this.mainTabs != null) {
                content.stack.recalculateLayout();
                this.mainTabs.selectPage(selectedPage);
            }
        }
    }

    @Nullable
    private static ResourceKey<WorldPreset> getConfiguredGeneratorKey(@Nullable Holder<WorldPreset> configuredPreset, @NotNull ResourceKey<LevelStem> forDimension) {
        ResourceKey<WorldPreset> overrideKey;
        ChunkGenerator chunkGenerator;
        LevelStem dimension;
        ResourceKey<WorldPreset> configuredKey = null;
        if (configuredPreset != null && (dimension = WorldPresetManager.getDimension(configuredPreset, forDimension)) != null && (chunkGenerator = dimension.generator()) instanceof ConfiguredChunkGenerator) {
            ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)chunkGenerator;
            configuredKey = cfg.wover_getConfiguredWorldPreset();
        }
        if (configuredKey == null && configuredPreset != null) {
            configuredKey = configuredPreset.unwrapKey().orElse(null);
        }
        return (overrideKey = WorldPresetInfoRegistry.getFor(configuredKey).getPresetOverrideRecursive(forDimension)) != null ? overrideKey : configuredKey;
    }

    private String languageKey(Holder<WorldPreset> key) {
        return this.languageKey(((ResourceKey)key.unwrapKey().orElseThrow()).location());
    }

    private String languageKey(ResourceLocation key) {
        return "generator." + key.getNamespace() + "." + key.getPath();
    }

    protected void populateGenerators(@Nullable Holder<WorldPreset> configuredPreset, @NotNull ResourceKey<LevelStem> forDimension, @NotNull DropDown<DimensionValue> dimensions) {
        ResourceKey<WorldPreset> finalConfiguredKey = WorldSetupScreen.getConfiguredGeneratorKey(configuredPreset, forDimension);
        DimensionValue selectedStem = null;
        Registry worldPresets = WorldState.allStageRegistryAccess().registryOrThrow(Registries.WORLD_PRESET);
        Optional normal = worldPresets.getTag(WorldPresetTags.NORMAL);
        if (normal.isPresent()) {
            HashSet generators = new HashSet();
            Language language = Language.getInstance();
            PriorityLinkedList options = new PriorityLinkedList();
            ((HolderSet.Named)normal.get()).stream().filter(preset -> preset.unwrapKey().isPresent()).filter(preset -> WorldPresetInfoRegistry.getFor((Holder<WorldPreset>)preset).getPresetOverride(forDimension) == null).sorted((a, b) -> language.getOrDefault(this.languageKey((Holder<WorldPreset>)a)).compareTo(language.getOrDefault(this.languageKey((Holder<WorldPreset>)b)))).forEach(preset -> {
                WorldPresetInfo info = WorldPresetInfoRegistry.getFor((Holder<WorldPreset>)preset);
                ResourceLocation presetKey = ((ResourceKey)preset.unwrapKey().orElseThrow()).location();
                Optional targetDimension = ((WorldPreset)preset.value()).createWorldDimensions().get(forDimension);
                if (targetDimension.isPresent()) {
                    ChunkGenerator generator = ((LevelStem)targetDimension.get()).generator();
                    if (!generators.contains(generator)) {
                        DimensionValue dimensionValue = new DimensionValue((Holder<WorldPreset>)preset, (ResourceKey<WorldPreset>)((ResourceKey)preset.unwrapKey().orElseThrow()), (LevelStem)targetDimension.get());
                        generators.add(generator);
                        options.add(dimensionValue, -1 * info.sortOrder());
                    } else {
                        LibWoverWorldGenerator.C.log.debug("Skipping duplicate generator for preset {}", presetKey);
                    }
                }
            });
            for (DimensionValue dimensionValue : options) {
                dimensions.addOption((Component)Component.translatable((String)this.languageKey(dimensionValue.preset)), (Object)dimensionValue);
                if (finalConfiguredKey == null || !dimensionValue.key.location().equals((Object)finalConfiguredKey.location())) continue;
                selectedStem = dimensionValue;
            }
        }
        boolean didSelect = false;
        if (selectedStem != null) {
            didSelect = dimensions.select(selectedStem);
        }
        if (!didSelect) {
            dimensions.selectFirst();
        }
    }

    private LayoutComponent<?, ?> contentPage(Holder<WorldPreset> configuredPreset, Component title, DimensionContent contentData) {
        VerticalStack content = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fit()).centerHorizontal();
        content.setDebugName("Stack " + String.valueOf(contentData.dimensionKey.location()));
        content.addSpacer(16);
        content.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), title).centerHorizontal();
        content.addHorizontalSeparator(8).alignTop();
        HorizontalStack generatorRow = content.addRow(Value.fill(), Value.fit());
        generatorRow.addText(Value.fit(), Value.fit(), (Component)Component.translatable((String)"title.screen.wover.worldgen.generator_template"));
        generatorRow.addSpacer(8);
        DropDown generators = generatorRow.addDropDown(Value.fixed((int)200), Value.fit());
        generators.onChange((__unused, selected) -> this.generatorChanged(contentData, (DimensionValue)selected));
        contentData.stackIndex = content.size();
        contentData.generators = generators;
        contentData.stack = content;
        this.populateGenerators(configuredPreset, contentData.dimensionKey, (DropDown<DimensionValue>)generators);
        return content;
    }

    private void updateSettings() {
        this.dimensions.values().forEach(content -> {
            if (content.generators == null) {
                return;
            }
            DimensionValue value = (DimensionValue)content.generators.selectedOption();
            if (value == null) {
                return;
            }
            ChunkGenerator generator = value.dimension.generator();
            if (content.configPanel != null) {
                generator = content.configPanel.updateSettings(generator);
            }
            if (generator instanceof ConfiguredChunkGenerator) {
                ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)generator;
                cfg.wover_setConfiguredWorldPreset(value.key);
            }
            this.updateConfiguration(content.dimensionKey, content.dimensionTypeKey, generator);
        });
        WorldDimensions dims = this.createWorldScreen.getUiState().getSettings().selectedDimensions();
        WorldSetupScreen.printDimensions(dims);
        WorldCreationUiState acc = this.createWorldScreen.getUiState();
        acc.setWorldType(new WorldCreationUiState.WorldTypeEntry(Holder.direct((Object)WorldPresetManager.withDimensions(dims))));
    }

    @Override
    public void updateConfiguration(ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey, ChunkGenerator chunkGenerator) {
        this.createWorldScreen.getUiState().updateDimensions((registryAccess, worldDimensions) -> {
            Map map = worldDimensions.dimensions();
            return new WorldDimensions(WoverChunkGeneratorImpl.replaceGenerator(dimensionKey, dimensionTypeKey, (RegistryAccess)registryAccess, map.entrySet(), chunkGenerator, key -> (LevelStem)map.get(key), (registry, key, stem) -> registry.register(key, (Object)stem, RegistrationInfo.BUILT_IN)));
        });
    }

    protected LayoutComponent<?, ?> createScreen(LayoutComponent<?, ?> content) {
        VerticalStack rows = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setDebugName("title stack");
        if (this.topPadding > 0) {
            rows.addSpacer(this.topPadding);
        }
        rows.add(content);
        if (this.bottomPadding > 0) {
            rows.addSpacer(this.bottomPadding);
        }
        if (this.sidePadding <= 0) {
            return rows;
        }
        HorizontalStack cols = (HorizontalStack)new HorizontalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setDebugName("padded side");
        cols.addSpacer(this.sidePadding);
        cols.add((LayoutComponent)rows);
        cols.addSpacer(this.sidePadding);
        return cols;
    }

    protected LayoutComponent<?, ?> initContent() {
        Tabs main;
        WorldCreationUiState acc = this.createWorldScreen.getUiState();
        Holder configuredPreset = acc.getWorldType().preset();
        if (configuredPreset != null) {
            this.dimensions.values().forEach(content -> {
                ChunkGenerator patt0$temp;
                LevelStem stem = WorldPresetManager.getDimension((Holder<WorldPreset>)configuredPreset, content.dimensionKey);
                if (stem != null && (patt0$temp = stem.generator()) instanceof ConfiguredChunkGenerator) {
                    ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)patt0$temp;
                    if (configuredPreset.unwrapKey().isPresent() && cfg.wover_getConfiguredWorldPreset() == null) {
                        cfg.wover_setConfiguredWorldPreset((ResourceKey<WorldPreset>)((ResourceKey)configuredPreset.unwrapKey().orElseThrow()));
                    }
                }
            });
        }
        this.mainTabs = main = new Tabs(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setPadding(8, 0, 0, 0);
        this.sortedDimensions.stream().map(type -> this.dimensions.get(type)).filter(content -> content != null).forEach(content -> {
            LayoutComponent<?, ?> page = this.contentPage((Holder<WorldPreset>)configuredPreset, (Component)Component.translatable((String)("title.screen.wover.worldgen." + content.dimensionKey.location().getPath() + "_generator")), (DimensionContent)content);
            if (!main.isEmpty()) {
                main.addSpacer(8);
            }
            this.scroller = (VerticalScroll)VerticalScroll.create(page).setDebugName(content.dimensionKey.location().getPath() + " scroll");
            main.addPage((Component)Component.translatable((String)("title.wover." + content.dimensionKey.location().getPath())), (LayoutComponent)this.scroller);
        });
        this.netherButton = main.getButton(this.sortedDimensions.indexOf(BuiltinDimensionTypes.NETHER));
        this.endButton = main.getButton(this.sortedDimensions.indexOf(BuiltinDimensionTypes.END));
        this.title = (HorizontalStack)((HorizontalStack)new HorizontalStack(WorldSetupScreen.fit(), WorldSetupScreen.fit()).setDebugName("title bar")).alignBottom();
        this.title.addImage(WorldSetupScreen.fixed((int)38), WorldSetupScreen.fixed((int)38), WoverLayoutScreen.WOVER_LOGO_LOCATION, Size.of((int)256)).setDebugName("icon");
        this.title.addSpacer(4);
        VerticalStack logos = this.title.addColumn(WorldSetupScreen.fit(), WorldSetupScreen.fit());
        logos.addSpacer(8);
        logos.addImage(WorldSetupScreen.fixed((int)59), WorldSetupScreen.fixed((int)13), WelcomeScreen.BETTERX_LOCATION, Size.of((int)178, (int)40));
        logos.add(super.createTitle());
        logos.addSpacer(2);
        main.addFiller();
        main.addComponent((LayoutComponent)this.title);
        VerticalStack rows = new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill());
        rows.add((LayoutComponent)main);
        rows.addSpacer(4);
        rows.addButton(WorldSetupScreen.fit(), WorldSetupScreen.fit(), CommonComponents.GUI_DONE).onPress(bt -> {
            this.updateSettings();
            this.onClose();
        }).alignRight();
        return rows;
    }

    private static void printDimensions(WorldDimensions dims) {
        if (!((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            return;
        }
        ChunkGeneratorManagerImpl.printDimensionInfo("Configured Dimensions", dims);
    }

    public void renderBackgroundLayer(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.fill(0, 0, this.width, this.height, -1120652220);
    }

    public static class DimensionContent {
        public final ResourceKey<LevelStem> dimensionKey;
        public final ResourceKey<DimensionType> dimensionTypeKey;
        private BiomeSourceConfigPanel<?, ?> configPanel;
        private DropDown<DimensionValue> generators;
        private VerticalStack stack;
        private int stackIndex = -1;

        private DimensionContent(ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey) {
            this.dimensionKey = dimensionKey;
            this.dimensionTypeKey = dimensionTypeKey;
        }
    }

    protected record DimensionValue(Holder<WorldPreset> preset, ResourceKey<WorldPreset> key, LevelStem dimension) {
    }
}

