/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.mixin.biomesource;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import org.betterx.wover.generator.impl.biomesource.nether.NetherBiomesHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiNoiseBiomeSourceParameterList.class})
public class MultiNoiseBiomeSourceParameterListMixin {
    @Shadow
    @Final
    @Mutable
    private Climate.ParameterList<Holder<Biome>> parameters;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void wover_addNetherBiomes(MultiNoiseBiomeSourceParameterList.Preset preset, HolderGetter<Biome> biomes, CallbackInfo ci) {
        if (preset != MultiNoiseBiomeSourceParameterList.Preset.NETHER) {
            return;
        }
        List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> additions = NetherBiomesHelper.getAdditions();
        if (additions.isEmpty()) {
            return;
        }
        ArrayList<Pair> updated = new ArrayList<Pair>(this.parameters.values());
        HashSet existing = new HashSet();
        for (Pair pair : updated) {
            ((Holder)pair.getSecond()).unwrapKey().ifPresent(existing::add);
        }
        for (Pair pair : additions) {
            if (existing.contains(pair.getSecond())) continue;
            try {
                Holder.Reference holder = biomes.getOrThrow((ResourceKey)pair.getSecond());
                updated.add(Pair.of((Object)((Climate.ParameterPoint)pair.getFirst()), (Object)holder));
            }
            catch (RuntimeException runtimeException) {}
        }
        this.parameters = new Climate.ParameterList(updated);
    }
}

