/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.item.api;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.item.api.smithing.SmithingTemplates;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;

public class ItemRegistry {
    private static final Map<ModCore, ItemRegistry> REGISTRIES = new HashMap<ModCore, ItemRegistry>();
    public final ModCore C;
    private final Map<ResourceLocation, Item> items = new LinkedHashMap<ResourceLocation, Item>();
    private Map<Item, TagKey<Item>[]> datagenTags;
    private Runnable initializer;
    private boolean initialized;

    private ItemRegistry(ModCore modeCore) {
        this.C = modeCore;
        if (ModCore.isDatagen()) {
            this.datagenTags = new HashMap<Item, TagKey<Item>[]>();
        }
    }

    public static Stream<ItemRegistry> streamAll() {
        return REGISTRIES.values().stream();
    }

    public static ItemRegistry forMod(ModCore modCore) {
        return REGISTRIES.computeIfAbsent(modCore, c -> new ItemRegistry(modCore));
    }

    public Stream<Item> allItems() {
        return this.items.values().stream();
    }

    public void setInitializer(Runnable initializer) {
        this.initializer = initializer;
    }

    private void ensureInitialized() {
        if (!this.initialized && this.initializer != null) {
            this.initialized = true;
            this.initializer.run();
        }
    }

    public <T extends Item> T register(String path, T item, TagKey<Item> ... tags) {
        if (item != null && item != Items.AIR) {
            ItemRegistry.ensureIntrusiveHolder(item);
            ResourceLocation id = this.C.mk(path);
            this.items.put(id, item);
            if (this.datagenTags != null && tags != null && tags.length > 0) {
                this.datagenTags.put(item, tags);
            }
        }
        return item;
    }

    private void performRegistration(RegisterEvent.RegisterHelper<Item> helper) {
        this.ensureInitialized();
        this.items.forEach((id, item) -> {
            ItemRegistry.ensureIntrusiveHolder(item);
            helper.register(id, item);
        });
    }

    private static void ensureIntrusiveHolder(Item item) {
        BuiltInRegistries.ITEM.createIntrusiveHolder((Object)item);
    }

    public static void onRegister(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            event.register(Registries.ITEM, helper -> REGISTRIES.values().forEach(reg -> reg.performRegistration((RegisterEvent.RegisterHelper<Item>)helper)));
        }
    }

    public static void hook(IEventBus bus) {
        bus.addListener(RegisterEvent.class, ItemRegistry::onRegister);
    }

    public <T extends Item> T registerAsTool(String path, T item, TagKey<Item> ... tags) {
        this.register(path, item, tags);
        return item;
    }

    public FoodProperties.Builder foodPropertiesOf(int hunger, float saturation, MobEffectInstance ... effects) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(hunger).saturationModifier(saturation);
        for (MobEffectInstance effect : effects) {
            builder.effect(effect, 1.0f);
        }
        return builder;
    }

    public FoodProperties.Builder drinkPropertiesOf(int hunger, float saturation) {
        return new FoodProperties.Builder().nutrition(hunger).saturationModifier(saturation);
    }

    public <T extends Item> T registerFood(String name, Function<Item.Properties, T> factory, int hunger, float saturation, MobEffectInstance ... effects) {
        return this.registerFood(name, factory, this.createDefaultItemSettings(), hunger, saturation, effects);
    }

    public <T extends Item> T registerFood(String name, Function<Item.Properties, T> factory, Item.Properties properties, int hunger, float saturation, MobEffectInstance ... effects) {
        return (T)this.register(name, (Item)factory.apply(properties.food(this.foodPropertiesOf(hunger, saturation, effects).build())), new TagKey[0]);
    }

    public <T extends Item> T registerDrink(String name, Function<Item.Properties, T> factory, int hunger, float saturation, MobEffectInstance ... effects) {
        return this.registerDrink(name, factory, this.createDefaultItemSettings(), hunger, saturation, effects);
    }

    public <T extends Item> T registerDrink(String name, Function<Item.Properties, T> factory, Item.Properties properties, int hunger, float saturation, MobEffectInstance ... effects) {
        return (T)this.register(name, (Item)factory.apply(properties.food(this.drinkPropertiesOf(hunger, saturation).build())), new TagKey[0]);
    }

    public <T extends SpawnEggItem> T registerEgg(String path, T item, TagKey<Item> ... tags) {
        DefaultDispenseItemBehavior behavior = new DefaultDispenseItemBehavior(this){

            public ItemStack execute(BlockSource pointer, ItemStack stack) {
                Direction direction = (Direction)pointer.state().getValue((Property)DispenserBlock.FACING);
                EntityType entityType = ((SpawnEggItem)stack.getItem()).getType(stack);
                entityType.spawn(pointer.level(), stack, null, pointer.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                stack.shrink(1);
                return stack;
            }
        };
        DispenserBlock.registerBehavior(item, (DispenseItemBehavior)behavior);
        return this.register(path, item, tags);
    }

    public SmithingTemplateItem registerSmithingTemplateItem(String path, List<ResourceLocation> baseSlotEmptyIcons, List<ResourceLocation> additionalSlotEmptyIcons) {
        SmithingTemplateItem item = SmithingTemplates.create(this.C, path).setBaseSlotEmptyIcons(baseSlotEmptyIcons).setAdditionalSlotEmptyIcons(additionalSlotEmptyIcons).build();
        return this.registerSmithingTemplateItem(path + "_smithing_template", item);
    }

    public <T extends SmithingTemplateItem> T registerSmithingTemplateItem(String path, T item) {
        this.register(path, item, (TagKey<Item>[])new TagKey[0]);
        return item;
    }

    public Item.Properties createDefaultItemSettings() {
        return new Item.Properties();
    }

    public void bootstrapItemTags(ItemTagBootstrapContext ctx) {
        if (this.datagenTags != null) {
            this.datagenTags.forEach(ctx::add);
        }
        this.items.entrySet().stream().filter(i -> i.getValue() instanceof ItemTagProvider).forEach(i -> ((ItemTagProvider)i.getValue()).registerItemTags((ResourceLocation)i.getKey(), ctx));
    }
}

