/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.math.api.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;

public class Vec3iProvider {
    public static final Codec<Vec3iProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("x").forGetter(o -> o.x), (App)IntProvider.CODEC.fieldOf("y").forGetter(o -> o.y), (App)IntProvider.CODEC.fieldOf("z").forGetter(o -> o.z)).apply((Applicative)instance, Vec3iProvider::new));
    public final IntProvider x;
    public final IntProvider y;
    public final IntProvider z;

    public static Codec<Vec3iProvider> codec(int i, int j) {
        return CODEC.validate(provider -> Vec3iProvider.validate(i, j, provider));
    }

    private static DataResult<Vec3iProvider> validate(int i, int j, Vec3iProvider provider) {
        if (provider.getMinValue() < i) {
            return DataResult.error(() -> "Value provider too low: " + i + " [" + provider.getMinValue() + "-" + provider.getMaxValue() + "]");
        }
        return provider.getMaxValue() > j ? DataResult.error(() -> "Value provider too high: " + j + " [" + provider.getMinValue() + "-" + provider.getMaxValue() + "]") : DataResult.success((Object)provider);
    }

    public Vec3iProvider(IntProvider x, IntProvider y, IntProvider z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i sample(RandomSource rnd) {
        return new Vec3i(this.x.sample(rnd), this.y.sample(rnd), this.z.sample(rnd));
    }

    public int getMinValue() {
        return Math.min(Math.min(this.x.getMinValue(), this.y.getMinValue()), this.z.getMinValue());
    }

    public int getMaxValue() {
        return Math.max(Math.max(this.x.getMaxValue(), this.y.getMaxValue()), this.z.getMaxValue());
    }
}

