/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.poi.api;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import org.betterx.wover.poi.impl.PoiManagerImpl;

public class WoverPoiType {
    public final ResourceKey<PoiType> key;
    public final PoiType type;
    public final Set<BlockState> matchingStates;
    public final int maxTickets;
    public final int validRange;

    public WoverPoiType(ResourceKey<PoiType> key, PoiType type, Set<BlockState> matchingStates, int maxTickets, int validRange) {
        this.key = key;
        this.type = type;
        this.matchingStates = matchingStates;
        this.maxTickets = maxTickets;
        this.validRange = validRange;
    }

    public static Set<BlockState> getBlockStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates());
    }

    public void setTag(TagKey<Block> tag) {
        PoiManagerImpl.setTag(this.key, tag);
    }

    public Optional<BlockPos> findPoiAround(ServerLevel level, BlockPos center, boolean wideSearch, WorldBorder worldBorder) {
        return WoverPoiType.findPoiAround(this.key, level, center, wideSearch, worldBorder);
    }

    public Optional<BlockPos> findClosest(ServerLevel level, BlockPos center, int radius) {
        return level.getPoiManager().findClosest(holder -> holder.is(this.key), pos -> true, center, radius, PoiManager.Occupancy.ANY);
    }

    public Optional<BlockPos> findPoiAround(ServerLevel level, BlockPos center, int radius, WorldBorder worldBorder) {
        return WoverPoiType.findPoiAround(this.key, level, center, radius, worldBorder);
    }

    public static Optional<BlockPos> findPoiAround(ResourceKey<PoiType> key, ServerLevel level, BlockPos center, boolean wideSearch, WorldBorder worldBorder) {
        return WoverPoiType.findPoiAround(key, level, center, wideSearch ? 16 : 128, worldBorder);
    }

    public static Optional<BlockPos> findPoiAround(ResourceKey<PoiType> key, ServerLevel level, BlockPos center, int radius, WorldBorder worldBorder) {
        PoiManager poiManager = level.getPoiManager();
        poiManager.ensureLoadedAndValid((LevelReader)level, center, radius);
        Optional<PoiRecord> record = poiManager.getInSquare(holder -> holder.is(key), center, radius, PoiManager.Occupancy.ANY).filter(poiRecord -> worldBorder.isWithinBounds(poiRecord.getPos())).sorted(Comparator.comparingDouble(poiRecord -> poiRecord.getPos().distSqr((Vec3i)center)).thenComparingInt(poiRecord -> poiRecord.getPos().getY())).filter(poiRecord -> level.getBlockState(poiRecord.getPos()).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).findFirst();
        return record.map(poiRecord -> poiRecord.getPos());
    }
}

