/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.api.context;

import com.mojang.serialization.Lifecycle;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.jetbrains.annotations.NotNull;

public class WorldPresetBootstrapContext
implements BootstrapContext<WorldPreset> {
    public final HolderGetter<NoiseGeneratorSettings> noiseSettings;
    public final HolderGetter<Biome> biomes;
    public final HolderGetter<PlacedFeature> placedFeatures;
    public final HolderGetter<StructureSet> structureSets;
    public final HolderGetter<MultiNoiseBiomeSourceParameterList> parameterLists;
    public final LevelStem overworldStem;
    public final Holder<DimensionType> overworldDimensionType;
    public final LevelStem netherStem;
    public final Holder<DimensionType> netherDimensionType;
    public final StemContext netherContext;
    public final LevelStem endStem;
    public final Holder<DimensionType> endDimensionType;
    public final StemContext endContext;
    private final BootstrapContext<WorldPreset> context;

    public WorldPresetBootstrapContext(BootstrapContext<WorldPreset> bootstapContext) {
        Holder.Reference endSettings;
        Holder.Reference netherSettings;
        NoiseBasedChunkGenerator nether;
        this.context = bootstapContext;
        this.parameterLists = bootstapContext.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
        HolderGetter dimensionTypes = bootstapContext.lookup(Registries.DIMENSION_TYPE);
        this.noiseSettings = bootstapContext.lookup(Registries.NOISE_SETTINGS);
        this.biomes = bootstapContext.lookup(Registries.BIOME);
        this.placedFeatures = bootstapContext.lookup(Registries.PLACED_FEATURE);
        this.structureSets = bootstapContext.lookup(Registries.STRUCTURE_SET);
        this.overworldDimensionType = dimensionTypes.getOrThrow(BuiltinDimensionTypes.OVERWORLD);
        Holder.Reference overworldParameters = this.parameterLists.getOrThrow(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
        MultiNoiseBiomeSource overworldBiomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)overworldParameters);
        Holder.Reference defaultOverworldNoise = this.noiseSettings.getOrThrow(NoiseGeneratorSettings.OVERWORLD);
        this.overworldStem = this.makeNoiseBasedOverworld((BiomeSource)overworldBiomeSource, (Holder<NoiseGeneratorSettings>)defaultOverworldNoise);
        this.netherDimensionType = dimensionTypes.getOrThrow(BuiltinDimensionTypes.NETHER);
        Holder.Reference netherParameters = this.parameterLists.getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER);
        Holder.Reference defaultNetherNoise = this.noiseSettings.getOrThrow(NoiseGeneratorSettings.NETHER);
        this.netherStem = new LevelStem(this.netherDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)netherParameters), (Holder)defaultNetherNoise));
        this.endDimensionType = dimensionTypes.getOrThrow(BuiltinDimensionTypes.END);
        Holder.Reference defaultEndNoise = this.noiseSettings.getOrThrow(NoiseGeneratorSettings.END);
        this.endStem = new LevelStem(this.endDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)TheEndBiomeSource.create(this.biomes), (Holder)defaultEndNoise));
        ChunkGenerator chunkGenerator = this.netherStem.generator();
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            nether = (NoiseBasedChunkGenerator)chunkGenerator;
            netherSettings = nether.generatorSettings();
        } else {
            netherSettings = this.noiseSettings.getOrThrow(NoiseGeneratorSettings.NETHER);
        }
        chunkGenerator = this.endStem.generator();
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            nether = (NoiseBasedChunkGenerator)chunkGenerator;
            endSettings = nether.generatorSettings();
        } else {
            endSettings = this.noiseSettings.getOrThrow(NoiseGeneratorSettings.END);
        }
        this.netherContext = new StemContext((Holder<DimensionType>)this.netherStem.type(), this.structureSets, (Holder<NoiseGeneratorSettings>)netherSettings);
        this.endContext = new StemContext((Holder<DimensionType>)this.endStem.type(), this.structureSets, (Holder<NoiseGeneratorSettings>)endSettings);
    }

    private LevelStem makeOverworld(ChunkGenerator chunkGenerator) {
        return new LevelStem(this.overworldDimensionType, chunkGenerator);
    }

    public LevelStem makeNoiseBasedOverworld(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> holder) {
        return this.makeOverworld((ChunkGenerator)new NoiseBasedChunkGenerator(biomeSource, holder));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Holder.Reference<WorldPreset> register(ResourceKey<WorldPreset> resourceKey, WorldPreset preset, Lifecycle lifecycle) {
        return this.context.register(resourceKey, (Object)preset, lifecycle);
    }

    public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> resourceKey) {
        return this.context.lookup(resourceKey);
    }

    public static class StemContext {
        public final Holder<DimensionType> dimension;
        public final HolderGetter<StructureSet> structureSets;
        public final Holder<NoiseGeneratorSettings> generatorSettings;

        private StemContext(Holder<DimensionType> dimension, HolderGetter<StructureSet> structureSets, Holder<NoiseGeneratorSettings> generatorSettings) {
            this.dimension = dimension;
            this.structureSets = structureSets;
            this.generatorSettings = generatorSettings;
        }

        public static StemContext of(Holder<DimensionType> dimension, HolderGetter<StructureSet> structureSets, Holder<NoiseGeneratorSettings> generatorSettings) {
            return new StemContext(dimension, structureSets, generatorSettings);
        }
    }
}

