/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.state.impl;

import com.google.gson.JsonObject;
import de.ambertation.wunderlib.configs.ConfigResource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import org.betterx.wover.config.api.DatapackConfigs;
import org.betterx.wover.events.api.WorldLifecycle;
import org.jetbrains.annotations.ApiStatus;

public class WorldDatapackConfigImpl {
    private static final Map<String, ConfigResource> CONFIGS = new HashMap<String, ConfigResource>();
    final List<LoadedItem> resources = new LinkedList<LoadedItem>();

    public static void registerConfig(ConfigResource config) {
        CONFIGS.put(config.location.getPath(), config);
    }

    @ApiStatus.Internal
    public static void initialize() {
        WorldLifecycle.BEFORE_LOADING_RESOURCES.subscribe(WorldDatapackConfigImpl::onResourcesLoaded, 100000000);
        WorldLifecycle.RESOURCES_LOADED.subscribe(WorldDatapackConfigImpl::onResourcesLoaded, 100000000);
    }

    private static void onResourcesLoaded(ResourceManager resourceManager, FeatureFlagSet featureFlagSet) {
        ConfigResource.invalidateCache();
    }

    private static void onResourcesLoaded(ResourceManager resourceManager) {
        CONFIGS.values().forEach(v -> v.setRootElement((JsonObject)null));
        List<String> paths = CONFIGS.keySet().stream().toList();
        WorldDatapackConfigImpl obj = new WorldDatapackConfigImpl();
        DatapackConfigs.instance().runForConfigPaths(resourceManager, paths, obj::processBiomeConfigs, obj::whenFinished);
    }

    private void processBiomeConfigs(ResourceLocation resourceLocation, JsonObject jsonObject) {
        ConfigResource config;
        int priority = 1000;
        boolean defaultPriority = true;
        if (jsonObject.has("priority") && jsonObject.get("priority").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("priority").isNumber()) {
            defaultPriority = false;
            priority = jsonObject.getAsJsonPrimitive("priority").getAsInt();
        }
        if ((config = CONFIGS.get(resourceLocation.getPath())) != null) {
            this.resources.add(new LoadedItem(resourceLocation, jsonObject, config, priority, defaultPriority));
        }
    }

    private void whenFinished() {
        this.resources.sort((a, b) -> {
            if (a.priority() == b.priority()) {
                return a.resource.compareTo(b.resource);
            }
            return a.priority() > b.priority() ? -1 : 1;
        });
        this.resources.forEach(v -> v.cfg.setRootElement(v.object));
    }

    private record LoadedItem(ResourceLocation resource, JsonObject object, ConfigResource cfg, int initialPriority, boolean defaultPriority) {
        public boolean isMaster() {
            return this.resource.getNamespace().equals(this.cfg.location.getNamespace());
        }

        public int priority() {
            if (this.defaultPriority && this.isMaster()) {
                return this.initialPriority * 2;
            }
            return this.initialPriority;
        }

        @Override
        public String toString() {
            return String.valueOf(this.resource) + " -> " + this.priority();
        }
    }
}

