/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api;

import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.StructureManager;
import org.betterx.wover.structure.api.StructureTypeKey;
import org.betterx.wover.structure.api.pools.StructurePoolKey;
import org.betterx.wover.structure.api.pools.StructurePoolManager;
import org.betterx.wover.structure.api.processors.StructureProcessorKey;
import org.betterx.wover.structure.api.processors.StructureProcessorManager;
import org.betterx.wover.structure.api.sets.StructureSetKey;
import org.betterx.wover.structure.api.sets.StructureSetManager;
import org.jetbrains.annotations.NotNull;

public class StructureKeys {
    public static StructureSetKey set(ResourceLocation location) {
        return StructureSetManager.createKey(location);
    }

    public static StructureSetKey set(StructureKey<?, ?, ?> structure) {
        return StructureKeys.set(structure.key().location());
    }

    public static StructureProcessorKey processor(ResourceLocation location) {
        return StructureProcessorManager.createKey(location);
    }

    public static StructurePoolKey pool(ResourceLocation location) {
        return StructurePoolManager.createKey(location);
    }

    public static <S extends Structure> StructureKey.Simple<S> structure(ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory, @NotNull MapCodec<S> codec) {
        return StructureManager.structure(location, structureFactory, codec);
    }

    public static <S extends Structure> StructureKey.Simple<S> structure(ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory) {
        return StructureManager.structure(location, structureFactory);
    }

    public static <S extends Structure> StructureKey.Simple<S> structure(ResourceLocation location, @NotNull StructureTypeKey<S> type) {
        return StructureManager.structure(location, type);
    }

    public static <S extends Structure> StructureKey.Jigsaw jigsaw(ResourceLocation location) {
        return StructureManager.jigsaw(location);
    }

    public static <S extends Structure> StructureKey.RandomNbt randomNbt(ResourceLocation location) {
        return StructureManager.randomNbt(location);
    }

    @NotNull
    public static <S extends Structure> StructureTypeKey<S> registerType(@NotNull ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory) {
        return StructureManager.registerType(location, structureFactory);
    }

    @NotNull
    public static <S extends Structure> StructureTypeKey<S> registerType(@NotNull ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory, @NotNull MapCodec<S> codec) {
        return StructureManager.registerType(location, structureFactory, codec);
    }

    @NotNull
    public static StructurePieceType registerPiece(@NotNull ResourceLocation location, @NotNull StructurePieceType pieceType) {
        return StructureManager.registerPiece(location, pieceType);
    }
}

