/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.betterx.wover.structure.impl.pools.StructurePoolElementTypeManagerImpl;

public class SingleEndPoolElement
extends SinglePoolElement {
    public static final MapCodec<SingleEndPoolElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SingleEndPoolElement.templateCodec(), (App)SingleEndPoolElement.processorsCodec(), (App)SingleEndPoolElement.projectionCodec()).apply((Applicative)instance, SingleEndPoolElement::new));

    public SingleEndPoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> holder, StructureTemplatePool.Projection projection) {
        this(either, holder, projection, Optional.empty());
    }

    public SingleEndPoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> holder, StructureTemplatePool.Projection projection, LiquidSettings liquidSettings) {
        this(either, holder, projection, Optional.of(liquidSettings));
    }

    protected SingleEndPoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> holder, StructureTemplatePool.Projection projection, Optional<LiquidSettings> liquidSettings) {
        super(either, holder, projection, liquidSettings);
    }

    public boolean place(StructureTemplateManager structureTemplateManager, WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos2, Rotation rotation, BoundingBox boundingBox, RandomSource randomSource, LiquidSettings liquidSettings, boolean bl) {
        boolean hasEmptySpace;
        if (blockPos.getY() < 5) {
            return false;
        }
        boolean bl2 = hasEmptySpace = worldGenLevel.isEmptyBlock(blockPos.above(2)) || worldGenLevel.isEmptyBlock(blockPos);
        if (!hasEmptySpace) {
            return false;
        }
        return super.place(structureTemplateManager, worldGenLevel, structureManager, chunkGenerator, blockPos, blockPos2, rotation, boundingBox, randomSource, liquidSettings, bl);
    }

    public StructurePoolElementType<?> getType() {
        return StructurePoolElementTypeManagerImpl.END;
    }

    public String toString() {
        return "SingleEnd[" + String.valueOf(this.template) + "]";
    }
}

