/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.processors;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import org.betterx.wover.structure.api.processors.StructureProcessorBuilder;
import org.jetbrains.annotations.NotNull;

public class StructureProcessorBuilderImpl
implements StructureProcessorBuilder {
    @NotNull
    private final ResourceKey<StructureProcessorList> key;
    @NotNull
    private final BootstrapContext<StructureProcessorList> context;
    private final List<StructureProcessor> list = new LinkedList<StructureProcessor>();

    public StructureProcessorBuilderImpl(@NotNull ResourceKey<StructureProcessorList> key, @NotNull BootstrapContext<StructureProcessorList> context) {
        this.key = key;
        this.context = context;
    }

    @Override
    public StructureProcessorBuilder add(@NotNull StructureProcessor processor) {
        this.list.add(processor);
        return this;
    }

    @Override
    public StructureProcessorBuilder.RuleProcessorBuilder startRule() {
        return new RuleProcessorBuilderImpl();
    }

    @Override
    public Holder<StructureProcessorList> register() {
        return this.context.register(this.key, (Object)this.build());
    }

    @Override
    public Holder<StructureProcessorList> directHolder() {
        return Holder.direct((Object)this.build());
    }

    private StructureProcessorList build() {
        return new StructureProcessorList(this.list);
    }

    public class RuleProcessorBuilderImpl
    implements StructureProcessorBuilder.RuleProcessorBuilder {
        private List<ProcessorRule> rules = new LinkedList<ProcessorRule>();

        private RuleProcessorBuilderImpl() {
        }

        @Override
        @NotNull
        public StructureProcessorBuilder.RuleProcessorBuilder add(@NotNull ProcessorRule rule) {
            this.rules.add(rule);
            return this;
        }

        @Override
        @NotNull
        public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder startProcessor() {
            return new ProcessorRuleBuilderImpl();
        }

        @Override
        @NotNull
        public StructureProcessorBuilder endRule() {
            return StructureProcessorBuilderImpl.this.add((StructureProcessor)new RuleProcessor(this.rules));
        }

        @Override
        @NotNull
        public StructureProcessorBuilder.RuleProcessorBuilder startRule() {
            return this.endRule().startRule();
        }

        public class ProcessorRuleBuilderImpl
        implements StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder {
            @NotNull
            private RuleTest inputPredicate = AlwaysTrueTest.INSTANCE;
            @NotNull
            private RuleTest locPredicate = AlwaysTrueTest.INSTANCE;
            @NotNull
            private PosRuleTest posPredicate = PosAlwaysTrueTest.INSTANCE;
            private BlockState outputState;
            @NotNull
            private RuleBlockEntityModifier blockEntityModifier = ProcessorRule.DEFAULT_BLOCK_ENTITY_MODIFIER;

            private ProcessorRuleBuilderImpl() {
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder inputPredicate(@NotNull RuleTest inputPredicate) {
                this.inputPredicate = inputPredicate;
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder inputPredicate(@NotNull Block block) {
                this.inputPredicate = new BlockMatchTest(block);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder inputPredicate(@NotNull BlockState block) {
                this.inputPredicate = new BlockStateMatchTest(block);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder inputPredicateRandom(@NotNull Block block, float chance) {
                this.inputPredicate = new RandomBlockMatchTest(block, chance);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder inputPredicateRandom(@NotNull BlockState block, float chance) {
                this.inputPredicate = new RandomBlockStateMatchTest(block, chance);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder locationAlways() {
                this.locPredicate = AlwaysTrueTest.INSTANCE;
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder locationPredicate(@NotNull RuleTest locPredicate) {
                this.locPredicate = locPredicate;
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder locationPredicateRandom(@NotNull Block block, float chance) {
                this.locPredicate = new RandomBlockMatchTest(block, chance);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder locationPredicateRandom(@NotNull BlockState block, float chance) {
                this.locPredicate = new RandomBlockStateMatchTest(block, chance);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder locationPredicate(@NotNull Block block) {
                this.locPredicate = new BlockMatchTest(block);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder locationPredicate(@NotNull BlockState block) {
                this.locPredicate = new BlockStateMatchTest(block);
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder positionPredicate(@NotNull PosRuleTest posPredicate) {
                this.posPredicate = posPredicate;
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder blockEntityModifier(@NotNull RuleBlockEntityModifier blockEntityModifier) {
                this.blockEntityModifier = blockEntityModifier;
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder outputState(@NotNull BlockState outputState) {
                this.outputState = outputState;
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder outputState(@NotNull Block outputBlock) {
                this.outputState = outputBlock.defaultBlockState();
                return this;
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder endProcessor() {
                if (this.outputState == null) {
                    throw new IllegalStateException("Output stet must be set");
                }
                return RuleProcessorBuilderImpl.this.add(new ProcessorRule(this.inputPredicate, this.locPredicate, this.posPredicate, this.outputState, this.blockEntityModifier));
            }

            @Override
            @NotNull
            public StructureProcessorBuilder.RuleProcessorBuilder.ProcessorRuleBuilder startProcessor() {
                return this.endProcessor().startProcessor();
            }
        }
    }
}

