/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.conditions;

import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.wover.surface.api.noise.NoiseParameterManager;
import org.betterx.wover.surface.mixin.SurfaceRulesContextAccessor;

public abstract class WoverRoughNoiseCondition
implements SurfaceRules.ConditionSource {
    protected abstract ResourceKey<NormalNoise.NoiseParameters> noise();

    protected abstract double minThreshold();

    protected abstract double maxThreshold();

    protected abstract FloatProvider roughness();

    public SurfaceRules.Condition apply(final SurfaceRules.Context context2) {
        final SurfaceRulesContextAccessor ctx = (SurfaceRulesContextAccessor)SurfaceRulesContextAccessor.class.cast(context2);
        final NormalNoise normalNoise = ctx.getRandomState().getOrCreateNoise(this.noise());
        final RandomSource roughnessSource = ctx.getRandomState().getOrCreateRandomFactory(NoiseParameterManager.ROUGHNESS_NOISE.location()).fromHashOf(NoiseParameterManager.ROUGHNESS_NOISE.location());
        class NoiseThresholdCondition
        extends SurfaceRules.LazyCondition {
            NoiseThresholdCondition() {
                super(context);
            }

            protected long getContextLastUpdate() {
                SurfaceRulesContextAccessor ctx2 = (SurfaceRulesContextAccessor)SurfaceRulesContextAccessor.class.cast(this.context);
                return ctx2.getLastUpdateY() + ctx2.getLastUpdateXZ();
            }

            protected boolean compute() {
                double d = normalNoise.getValue((double)ctx.getBlockX(), (double)ctx.getBlockY(), (double)ctx.getBlockZ()) + (double)WoverRoughNoiseCondition.this.roughness().sample(roughnessSource);
                return d >= WoverRoughNoiseCondition.this.minThreshold() && d <= WoverRoughNoiseCondition.this.maxThreshold();
            }
        }
        return new NoiseThresholdCondition();
    }
}

