/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.numeric;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.betterx.wover.math.api.MathHelper;
import org.betterx.wover.surface.api.conditions.SurfaceRulesContext;
import org.betterx.wover.surface.api.noise.NumericProvider;

public final class RandomIntProvider
implements NumericProvider {
    public static final MapCodec<RandomIntProvider> CODEC = Codec.INT.fieldOf("range").xmap(RandomIntProvider::new, obj -> obj.range);
    public final int range;
    private final RandomSource random;

    RandomIntProvider(int range) {
        this.range = range;
        this.random = new XoroshiroRandomSource(MathHelper.getSeed(range));
    }

    public static RandomIntProvider max(int range) {
        return new RandomIntProvider(range);
    }

    @Override
    public int getNumber(SurfaceRulesContext context) {
        return this.random.nextInt(this.range);
    }

    @Override
    public MapCodec<? extends NumericProvider> pcodec() {
        return CODEC;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RandomIntProvider that = (RandomIntProvider)obj;
        return this.range == that.range;
    }

    public int hashCode() {
        return Objects.hash(this.range);
    }

    public String toString() {
        return "RandomIntProvider[range=" + this.range + "]";
    }
}

