/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.datagen;

import java.util.List;
import java.util.Set;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.betterx.wover.tag.api.predefined.CommonPoiTags;
import org.betterx.wover.tag.api.predefined.MineableTags;
import org.betterx.wover.tag.datagen.WoverTagDatagen;

public class BlockTagProvider
extends WoverTagProvider.ForBlocks {
    public BlockTagProvider(ModCore modCore) {
        super(modCore, List.of(modCore.namespace, modCore.modId, "c", "minecraft"), Set.of(CommonBlockTags.NETHER_MYCELIUM, CommonBlockTags.BARREL, CommonBlockTags.WOODEN_CHEST, CommonBlockTags.WOODEN_COMPOSTER, CommonBlockTags.WOODEN_BARREL, CommonBlockTags.WORKBENCHES, MineableTags.NEEDS_GOLD_TOOL, MineableTags.NEEDS_NETHERITE_TOOL, MineableTags.NEEDS_WOOD_TOOL, CommonBlockTags.MYCELIUM, CommonBlockTags.END_STONES, CommonBlockTags.NETHER_TERRAIN));
    }

    @Override
    protected boolean initAll() {
        return true;
    }

    @Override
    public void prepareTags(TagBootstrapContext<Block> ctx) {
        BlockTagProvider.prepareBlockTags(ctx);
        BlockTagProvider.preparePOITags(ctx);
    }

    public static void preparePOITags(TagBootstrapContext<Block> ctx) {
        ctx.add(CommonPoiTags.ARMORER_WORKSTATION, (Block[])new Block[]{Blocks.BLAST_FURNACE});
        ctx.add(CommonPoiTags.BUTCHER_WORKSTATION, (Block[])new Block[]{Blocks.SMOKER});
        ctx.add(CommonPoiTags.CARTOGRAPHER_WORKSTATION, (Block[])new Block[]{Blocks.CARTOGRAPHY_TABLE});
        ctx.add(CommonPoiTags.CLERIC_WORKSTATION, (Block[])new Block[]{Blocks.BREWING_STAND});
        ctx.add(CommonPoiTags.FARMER_WORKSTATION, (Block[])new Block[]{Blocks.COMPOSTER});
        ctx.add(CommonPoiTags.FISHERMAN_WORKSTATION, CommonBlockTags.BARREL, CommonBlockTags.WOODEN_BARREL);
        ctx.add(CommonPoiTags.FLETCHER_WORKSTATION, (Block[])new Block[]{Blocks.FLETCHING_TABLE});
        ctx.add(CommonPoiTags.LEATHERWORKER_WORKSTATION, CommonBlockTags.CAULDRONS);
        ctx.add(CommonPoiTags.LIBRARIAN_WORKSTATION, (Block[])new Block[]{Blocks.LECTERN});
        ctx.add(CommonPoiTags.MASON_WORKSTATION, (Block[])new Block[]{Blocks.STONECUTTER});
        ctx.add(CommonPoiTags.SHEPHERD_WORKSTATION, (Block[])new Block[]{Blocks.LOOM});
        ctx.add(CommonPoiTags.TOOLSMITH_WORKSTATION, (Block[])new Block[]{Blocks.SMITHING_TABLE});
        ctx.add(CommonPoiTags.WEAPONSMITH_WORKSTATION, (Block[])new Block[]{Blocks.GRINDSTONE});
        ctx.add(CommonPoiTags.HOME, CommonBlockTags.BEDS);
        ctx.add(CommonPoiTags.MEETING_PLACE, (Block[])new Block[]{Blocks.BELL});
        ctx.add(CommonPoiTags.BEEHIVE, (Block[])new Block[]{Blocks.BEEHIVE});
        ctx.add(CommonPoiTags.BEE_NEST, (Block[])new Block[]{Blocks.BEE_NEST});
        ctx.add(CommonPoiTags.NETHER_PORTAL, (Block[])new Block[]{Blocks.NETHER_PORTAL});
        ctx.add(CommonPoiTags.LODESTONE, (Block[])new Block[]{Blocks.LODESTONE});
        ctx.add(CommonPoiTags.LIGHTNING_ROD, (Block[])new Block[]{Blocks.LIGHTNING_ROD});
        ctx.addOptional(WoverTagDatagen.VILLAGER_JOB_SITES, CommonPoiTags.ARMORER_WORKSTATION, CommonPoiTags.BUTCHER_WORKSTATION, CommonPoiTags.CARTOGRAPHER_WORKSTATION, CommonPoiTags.CLERIC_WORKSTATION, CommonPoiTags.FARMER_WORKSTATION, CommonPoiTags.FISHERMAN_WORKSTATION, CommonPoiTags.FLETCHER_WORKSTATION, CommonPoiTags.LEATHERWORKER_WORKSTATION, CommonPoiTags.LIBRARIAN_WORKSTATION, CommonPoiTags.MASON_WORKSTATION, CommonPoiTags.SHEPHERD_WORKSTATION, CommonPoiTags.TOOLSMITH_WORKSTATION, CommonPoiTags.WEAPONSMITH_WORKSTATION);
    }

    public static void prepareBlockTags(TagBootstrapContext<Block> ctx) {
        ctx.add(MineableTags.HAMMER, BlockTags.MINEABLE_WITH_PICKAXE);
        ctx.add(CommonBlockTags.SCULK_LIKE, (Block[])new Block[]{Blocks.SCULK});
        ctx.add(CommonBlockTags.END_STONES, (Block[])new Block[]{Blocks.END_STONE});
        ctx.add(CommonBlockTags.NETHER_STONES, BlockTags.BASE_STONE_NETHER);
        ctx.add(CommonBlockTags.NETHERRACK, (Block[])new Block[]{Blocks.NETHERRACK, Blocks.NETHER_QUARTZ_ORE, Blocks.NETHER_GOLD_ORE, Blocks.CRIMSON_NYLIUM, Blocks.WARPED_NYLIUM});
        ctx.add(CommonBlockTags.NETHER_ORES, (Block[])new Block[]{Blocks.NETHER_QUARTZ_ORE, Blocks.NETHER_GOLD_ORE});
        ctx.add(CommonBlockTags.SOUL_GROUND, (Block[])new Block[]{Blocks.SOUL_SAND, Blocks.SOUL_SOIL});
        ctx.add(CommonBlockTags.IS_OBSIDIAN, (Block[])new Block[]{Blocks.OBSIDIAN, Blocks.CRYING_OBSIDIAN});
        ctx.add(CommonBlockTags.MYCELIUM, (Block[])new Block[]{Blocks.MYCELIUM});
        ctx.addOptional(CommonBlockTags.MYCELIUM, CommonBlockTags.NETHER_MYCELIUM);
        ctx.add(CommonBlockTags.TERRAIN, (Block[])new Block[]{Blocks.MAGMA_BLOCK, Blocks.GRAVEL, Blocks.SAND, Blocks.RED_SAND, Blocks.GLOWSTONE, Blocks.BONE_BLOCK, Blocks.SCULK, Blocks.DIRT, Blocks.FARMLAND, Blocks.GRASS_BLOCK});
        ctx.add(CommonBlockTags.TERRAIN, BlockTags.DRIPSTONE_REPLACEABLE, BlockTags.BASE_STONE_OVERWORLD, BlockTags.NYLIUM);
        ctx.addOptional(CommonBlockTags.TERRAIN, CommonBlockTags.NETHER_TERRAIN, CommonBlockTags.MYCELIUM, CommonBlockTags.END_STONES);
        ctx.add(CommonBlockTags.NETHER_TERRAIN, (Block[])new Block[]{Blocks.MAGMA_BLOCK, Blocks.GRAVEL, Blocks.RED_SAND, Blocks.GLOWSTONE, Blocks.BONE_BLOCK, Blocks.BLACKSTONE});
        ctx.add(CommonBlockTags.NETHER_TERRAIN, BlockTags.NYLIUM);
        ctx.addOptional(CommonBlockTags.NETHER_TERRAIN, CommonBlockTags.NETHERRACK, CommonBlockTags.NETHER_ORES, CommonBlockTags.SOUL_GROUND, CommonBlockTags.NETHER_MYCELIUM);
        ctx.add(CommonBlockTags.BOOKSHELVES, (Block[])new Block[]{Blocks.BOOKSHELF});
        ctx.add(CommonBlockTags.CHEST, (Block[])new Block[]{Blocks.CHEST});
        ctx.add((TagKey<Block>)BlockTags.NETHER_CARVER_REPLACEABLES, (Block[])new Block[]{Blocks.BASALT, Blocks.RED_SAND, Blocks.MAGMA_BLOCK, Blocks.SCULK});
        ctx.add((TagKey<Block>)BlockTags.NETHER_CARVER_REPLACEABLES, CommonBlockTags.NETHER_STONES, CommonBlockTags.NETHERRACK);
        ctx.add((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, CommonBlockTags.WOODEN_BARREL, CommonBlockTags.WOODEN_COMPOSTER, CommonBlockTags.WOODEN_CHEST, CommonBlockTags.WORKBENCHES);
        ctx.add(CommonBlockTags.WATER_PLANT, (Block[])new Block[]{Blocks.KELP, Blocks.KELP_PLANT, Blocks.SEAGRASS, Blocks.TALL_SEAGRASS});
        ctx.add(CommonBlockTags.SAPLINGS, (Block[])new Block[]{Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.CHERRY_SAPLING, Blocks.BAMBOO_SAPLING, Blocks.MANGROVE_PROPAGULE});
        ctx.add(CommonBlockTags.PLANT, CommonBlockTags.SAPLINGS, CommonBlockTags.VINE);
        ctx.add(CommonBlockTags.PLANT, (Block[])new Block[]{Blocks.MANGROVE_LEAVES, Blocks.SHORT_GRASS, Blocks.FERN, Blocks.DANDELION, Blocks.TORCHFLOWER, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.WITHER_ROSE, Blocks.LILY_OF_THE_VALLEY, Blocks.WHEAT, Blocks.CACTUS, Blocks.SUGAR_CANE, Blocks.ATTACHED_PUMPKIN_STEM, Blocks.ATTACHED_MELON_STEM, Blocks.PUMPKIN_STEM, Blocks.MELON_STEM, Blocks.VINE, Blocks.LILY_PAD, Blocks.COCOA, Blocks.CARROTS, Blocks.POTATOES, Blocks.SUNFLOWER, Blocks.LILAC, Blocks.ROSE_BUSH, Blocks.PEONY, Blocks.TALL_GRASS, Blocks.LARGE_FERN, Blocks.TORCHFLOWER_CROP, Blocks.PITCHER_CROP, Blocks.PITCHER_PLANT, Blocks.BEETROOTS, Blocks.BAMBOO, Blocks.SWEET_BERRY_BUSH, Blocks.CAVE_VINES, Blocks.CAVE_VINES_PLANT, Blocks.SPORE_BLOSSOM, Blocks.AZALEA, Blocks.FLOWERING_AZALEA, Blocks.PINK_PETALS, Blocks.BIG_DRIPLEAF, Blocks.BIG_DRIPLEAF_STEM, Blocks.SMALL_DRIPLEAF});
        ctx.add(CommonBlockTags.SOIL_OR_LOGS, BlockTags.DIRT, BlockTags.LOGS, BlockTags.PLANKS);
        ctx.addOptional(CommonBlockTags.SOIL_OR_LOGS, CommonBlockTags.TERRAIN);
        ctx.addOptional((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, MineableTags.NEEDS_NETHERITE_TOOL);
        ctx.addOptional((TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, MineableTags.NEEDS_GOLD_TOOL);
        ctx.addOptional(WoverTagDatagen.VILLAGER_JOB_SITES, CommonPoiTags.FARMER_WORKSTATION, CommonPoiTags.FISHERMAN_WORKSTATION);
        ctx.add(CommonBlockTags.CAULDRONS, (Block[])new Block[]{Blocks.LAVA_CAULDRON, Blocks.WATER_CAULDRON, Blocks.POWDER_SNOW_CAULDRON});
        ctx.add(CommonBlockTags.BEDS, (Block[])new Block[]{Blocks.RED_BED, Blocks.BLACK_BED, Blocks.BLUE_BED, Blocks.BROWN_BED, Blocks.CYAN_BED, Blocks.GRAY_BED, Blocks.GREEN_BED, Blocks.LIGHT_BLUE_BED, Blocks.LIGHT_GRAY_BED, Blocks.LIME_BED, Blocks.MAGENTA_BED, Blocks.ORANGE_BED, Blocks.PINK_BED, Blocks.PURPLE_BED, Blocks.WHITE_BED, Blocks.YELLOW_BED});
    }
}

