/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import org.betterx.wover.util.RandomizedWeightedList;

public class RandomizedWeightedList<T> {
    private final List<WeightedEntry<T>> entries;
    private double totalWeight;

    public static <T> Codec<RandomizedWeightedList<T>> buildCodec(Codec<T> elementCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)WeightedEntry.buildElementCodec(elementCodec).listOf()).fieldOf("items").forGetter(cfg -> cfg.entries)).apply((Applicative)instance, RandomizedWeightedList::new));
    }

    private RandomizedWeightedList(List<WeightedEntry<T>> entries) {
        this.entries = entries;
        this.totalWeight = entries.stream().map((? super T w) -> w.weight).reduce(0.0, Double::sum);
    }

    public RandomizedWeightedList() {
        this.entries = new LinkedList<WeightedEntry<T>>();
        this.totalWeight = 0.0;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public void add(T value, double weight) {
        if (weight <= 0.0) {
            throw new IllegalArgumentException("Weight must be greater than zero.");
        }
        this.entries.add(new WeightedEntry<T>(value, weight));
        this.totalWeight += weight;
    }

    public void remove(T value) {
        for (WeightedEntry<T> entry : this.entries) {
            if (!entry.getValue().equals(value)) continue;
            this.totalWeight -= entry.getWeight();
            this.entries.remove(entry);
            return;
        }
    }

    public T getRandomValue(Random random) {
        return this.getRandomValue(random::nextDouble);
    }

    public T getRandomValue(RandomSource random) {
        return this.getRandomValue(() -> ((RandomSource)random).nextDouble());
    }

    public <R> RandomizedWeightedList<R> map(Function<T, R> mapper) {
        RandomizedWeightedList<R> res = new RandomizedWeightedList<R>();
        for (WeightedEntry<T> e : this.entries) {
            res.add(mapper.apply(e.getValue()), e.getWeight());
        }
        return res;
    }

    public void forEach(BiConsumer<T, Double> consumer) {
        for (WeightedEntry<T> e : this.entries) {
            consumer.accept(e.getValue(), e.getWeight());
        }
    }

    private T getRandomValue(RandomValueSupplier rnd) {
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("The list is empty.");
        }
        double randomValue = rnd.nextDouble() * this.totalWeight;
        double cumulativeWeight = 0.0;
        for (WeightedEntry<T> entry : this.entries) {
            if (!(randomValue < (cumulativeWeight += entry.getWeight()))) continue;
            return entry.getValue();
        }
        return this.entries.get(this.entries.size() - 1).getValue();
    }

    public static <E> RandomizedWeightedList<E> of() {
        return new RandomizedWeightedList();
    }

    public static <E> RandomizedWeightedList<E> of(E e1) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e1, 1.0);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9, E e10, Double w10) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        l.add(e10, w10);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9, E e10, Double w10, E e11, Double w11) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        l.add(e10, w10);
        l.add(e11, w11);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9, E e10, Double w10, E e11, Double w11, E e12, Double w12) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        l.add(e10, w10);
        l.add(e11, w11);
        l.add(e12, w12);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9, E e10, Double w10, E e11, Double w11, E e12, Double w12, E e13, Double w13) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        l.add(e10, w10);
        l.add(e11, w11);
        l.add(e12, w12);
        l.add(e13, w13);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9, E e10, Double w10, E e11, Double w11, E e12, Double w12, E e13, Double w13, E e14, Double w14) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        l.add(e10, w10);
        l.add(e11, w11);
        l.add(e12, w12);
        l.add(e13, w13);
        l.add(e14, w14);
        return l;
    }

    public static <E> RandomizedWeightedList<E> of(E e0, Double w0, E e1, Double w1, E e2, Double w2, E e3, Double w3, E e4, Double w4, E e5, Double w5, E e6, Double w6, E e7, Double w7, E e8, Double w8, E e9, Double w9, E e10, Double w10, E e11, Double w11, E e12, Double w12, E e13, Double w13, E e14, Double w14, E e15, Double w15) {
        RandomizedWeightedList<E> l = new RandomizedWeightedList<E>();
        l.add(e0, w0);
        l.add(e1, w1);
        l.add(e2, w2);
        l.add(e3, w3);
        l.add(e4, w4);
        l.add(e5, w5);
        l.add(e6, w6);
        l.add(e7, w7);
        l.add(e8, w8);
        l.add(e9, w9);
        l.add(e10, w10);
        l.add(e11, w11);
        l.add(e12, w12);
        l.add(e13, w13);
        l.add(e14, w14);
        l.add(e15, w15);
        return l;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public RandomizedWeightedList<T> subList(int fromIndex, int toIndex) {
        return new RandomizedWeightedList<T>(this.entries.subList(fromIndex, toIndex));
    }

    public SearchTree buildSearchTree() {
        return new SearchTree(this);
    }

    private static class WeightedEntry<T> {
        private final T value;
        private final double weight;

        public static <T> Codec<WeightedEntry<T>> buildElementCodec(Codec<T> elementCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)elementCodec.fieldOf("value").forGetter(WeightedEntry::getValue), (App)Codec.DOUBLE.fieldOf("weight").orElse((Object)1.0).forGetter(WeightedEntry::getWeight)).apply((Applicative)instance, WeightedEntry::new));
        }

        public WeightedEntry(T value, double weight) {
            this.value = value;
            this.weight = weight;
        }

        public T getValue() {
            return this.value;
        }

        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeightedEntry)) {
                return false;
            }
            WeightedEntry that = (WeightedEntry)o;
            return Double.compare(that.weight, this.weight) == 0 && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.weight);
        }
    }

    @FunctionalInterface
    private static interface RandomValueSupplier {
        public double nextDouble();
    }

    public class SearchTree {
        private final org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node root;

        private SearchTree(RandomizedWeightedList<T> list) {
            this.root = this.getNode(list);
        }

        private T getRandomValue(RandomFloatValueSupplier random) {
            return this.root.get(random.nextFloat() * (float)RandomizedWeightedList.this.totalWeight);
        }

        public T getRandomValue(Random random) {
            return this.getRandomValue(random::nextFloat);
        }

        public T getRandomValue(RandomSource random) {
            return this.getRandomValue(() -> ((RandomSource)random).nextFloat());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEmpty() {
            if (this.root == null) return true;
            org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node node = this.root;
            if (!(node instanceof Leaf)) return false;
            Leaf l = (Leaf)node;
            if (l.biome != null) return false;
            return true;
        }

        private org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node getNode(RandomizedWeightedList<T> list) {
            ArrayList<Float> cumulativeWeights = new ArrayList<Float>(list.size());
            float sum = 0.0f;
            for (int i = 0; i < list.size(); ++i) {
                cumulativeWeights.add(Float.valueOf(sum += (float)list.entries.get((int)i).weight));
            }
            return this.getNode(list, cumulativeWeights);
        }

        private org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node getNode(RandomizedWeightedList<T> list, List<Float> cumulativeWeights) {
            int size = list.size();
            if (size == 0) {
                return new Leaf(this, null);
            }
            if (size == 1) {
                return new Leaf(this, list.entries.get((int)0).value);
            }
            if (size == 2) {
                return new Branch(this, cumulativeWeights.get(0).floatValue(), (Node)new Leaf(this, list.entries.get((int)0).value), (Node)new Leaf(this, list.entries.get((int)1).value));
            }
            int midIndex = size >> 1;
            float separator = cumulativeWeights.get(midIndex - 1).floatValue();
            Node lower = this.getNode(list.subList(0, midIndex), cumulativeWeights.subList(0, midIndex));
            Node upper = this.getNode(list.subList(midIndex, size), cumulativeWeights.subList(midIndex, size));
            return new Branch(this, separator, lower, upper);
        }

        public String toString() {
            return this.root.toString();
        }

        private abstract class Node {
            private Node(SearchTree searchTree) {
            }

            abstract T get(float var1);
        }

        @FunctionalInterface
        private static interface RandomFloatValueSupplier {
            public float nextFloat();
        }

        /*
         * Signature claims super is org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node, not org.betterx.wover.util.RandomizedWeightedList$SearchTree$Node - discarding signature.
         */
        private class Leaf
        extends Node {
            final T biome;

            Leaf(SearchTree searchTree, T value) {
                super(searchTree);
                this.biome = value;
            }

            @Override
            T get(float value) {
                return this.biome;
            }

            public String toString() {
                return String.format(Locale.ROOT, "[%s]", this.biome.toString());
            }
        }

        /*
         * Signature claims super is org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node, not org.betterx.wover.util.RandomizedWeightedList$SearchTree$Node - discarding signature.
         */
        private class Branch
        extends Node {
            final float separator;
            final org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node min;
            final org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node max;

            public Branch(float separator, org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node min, org.betterx.wover.util.RandomizedWeightedList$SearchTree.Node max) {
                super(var1_1);
                this.separator = separator;
                this.min = min;
                this.max = max;
            }

            @Override
            T get(float value) {
                return value < this.separator ? this.min.get(value) : this.max.get(value);
            }

            public String toString() {
                return String.format(Locale.ROOT, "[%f, %s, %s]", Float.valueOf(this.separator), this.min.toString(), this.max.toString());
            }
        }
    }
}

