/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.block.custom;

import com.kaironeybaloney.hadeandepths.block.entity.ButcheringHookBlockEntity;
import com.kaironeybaloney.hadeandepths.entity.HangingFishEntity;
import com.kaironeybaloney.hadeandepths.item.ModItems;
import com.kaironeybaloney.hadeandepths.item.custom.FishItem;
import com.kaironeybaloney.hadeandepths.item.custom.FishRarity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ButcheringHookBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public final VoxelShape SHAPE = this.makeShape();

    public ButcheringHookBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        boolean water = level.getFluidState(pos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction == Direction.UP && !state.canSurvive(world, pos)) {
            if (world instanceof Level) {
                Level level = (Level)world;
                level.destroyBlock(pos, true);
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, world, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.46875, (double)0.3125, (double)0.46875, (double)0.53125, (double)0.4375, (double)0.53125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.125, (double)0.21875, (double)0.5, (double)0.3125, (double)0.78125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.40625, (double)0.6875, (double)0.5, (double)0.59375, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.6875, (double)0.40625, (double)0.5, (double)1.0, (double)0.59375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.4375, (double)0.375, (double)0.625, (double)0.6875, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4062499999999999, (double)0.6875, (double)0.40625, (double)0.5937499999999999, (double)1.0, (double)0.5937500000000001), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)0.125, (double)0.5, (double)0.78125, (double)0.3125, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ButcheringHookBlockEntity(blockPos, blockState);
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof ButcheringHookBlockEntity)) {
            return InteractionResult.PASS;
        }
        ButcheringHookBlockEntity hookBE = (ButcheringHookBlockEntity)be;
        if (!level.isClientSide) {
            Direction face = hit.getDirection();
            if (face == Direction.UP || face == Direction.DOWN) {
                Vec3 playerPos = player.position();
                Vec3 blockCenter = Vec3.atCenterOf((Vec3i)pos);
                double dx = playerPos.x - blockCenter.x;
                double dz = playerPos.z - blockCenter.z;
                face = Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? Direction.EAST : Direction.WEST) : (dz > 0.0 ? Direction.SOUTH : Direction.NORTH);
            }
            hookBE.setClickedFace(face);
        }
        ItemStack held = player.getItemInHand(hand);
        TagKey FISH_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fish"));
        TagKey BUTCHERING_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"butchering_item"));
        if (held.is(BUTCHERING_TAG) && !hookBE.isEmpty()) {
            ItemStack fishStack = hookBE.getItem();
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            this.dropFishLoot(level, pos, hookBE.getItem());
            Item dz = fishStack.getItem();
            if (dz instanceof FishItem) {
                FishItem fishItem = (FishItem)dz;
                FishRarity rarity = fishItem.getRarity(fishStack);
                double randomValue = level.random.nextDouble();
                switch (rarity) {
                    case COMMON: {
                        if (!(randomValue <= 0.02)) break;
                        Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() - 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)ModItems.DEEP_SEA_RESIDUE.toStack(1));
                        break;
                    }
                    case UNCOMMON: {
                        if (!(randomValue <= 0.06)) break;
                        Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() - 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)ModItems.DEEP_SEA_RESIDUE.toStack(1));
                        break;
                    }
                    case RARE: {
                        if (!(randomValue <= 0.18)) break;
                        Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() - 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)ModItems.DEEP_SEA_RESIDUE.toStack(1));
                        break;
                    }
                    case LEGENDARY: {
                        if (randomValue <= 0.5) {
                            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)(pos.getY() - 1), (double)((double)pos.getZ() + 0.5), (ItemStack)ModItems.DEEP_SEA_RESIDUE.toStack(1));
                        }
                        Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)(pos.getY() - 1), (double)((double)pos.getZ() + 0.5), (ItemStack)ModItems.LEGENDARY_HEART.toStack(1));
                    }
                }
            }
            ItemStack removed = hookBE.removeItem();
            hookBE.setChanged();
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            return InteractionResult.SUCCESS;
        }
        if (held.isEmpty()) {
            ItemStack removed = hookBE.removeItem();
            if (!removed.isEmpty()) {
                if (!player.getInventory().add(removed.copy())) {
                    player.drop(removed.copy(), false);
                }
                level.sendBlockUpdated(pos, state, state, 3);
                hookBE.setChanged();
            }
            return InteractionResult.SUCCESS;
        }
        if (held.is(FISH_TAG)) {
            if (hookBE.isEmpty()) {
                level.playSound(null, pos, SoundEvents.SALMON_FLOP, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                ItemStack toInsert = held.copy();
                toInsert.setCount(1);
                hookBE.setItem(toInsert);
                if (!player.isCreative()) {
                    held.shrink(1);
                }
                level.sendBlockUpdated(pos, state, state, 3);
                hookBE.setChanged();
                return InteractionResult.SUCCESS;
            }
            level.playSound(null, pos, SoundEvents.SALMON_FLOP, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            ItemStack removed = hookBE.removeItem();
            if (!removed.isEmpty()) {
                if (!player.getInventory().add(removed.copy())) {
                    player.drop(removed.copy(), false);
                }
                level.sendBlockUpdated(pos, state, state, 3);
                hookBE.setChanged();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void dropFishLoot(Level level, BlockPos pos, ItemStack fish) {
        if (fish.isEmpty() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FishRarity rarity = FishRarity.COMMON;
        Item item = fish.getItem();
        if (item instanceof FishItem) {
            FishItem fishItem = (FishItem)item;
            rarity = fishItem.getRarity(fish);
        }
        boolean isLegendary = rarity == FishRarity.LEGENDARY;
        ResourceLocation fishID = BuiltInRegistries.ITEM.getKey((Object)fish.getItem());
        ResourceLocation lootTableID = ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)("butchering/" + fishID.getPath()));
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableID);
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableKey);
        LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK);
        ObjectArrayList drops = lootTable.getRandomItems(params);
        for (ItemStack stack : drops) {
            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)(isLegendary ? (double)(pos.getY() - 1) : (double)pos.getY() - 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)stack);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof ButcheringHookBlockEntity) {
                ButcheringHookBlockEntity hookBE = (ButcheringHookBlockEntity)be;
                hookBE.drops();
            }
            level.getEntitiesOfClass(HangingFishEntity.class, new AABB(pos)).forEach(Entity::discard);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

