/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.block.entity;

import com.kaironeybaloney.hadeandepths.block.entity.ModBlockEntities;
import com.kaironeybaloney.hadeandepths.entity.HangingFishEntity;
import com.kaironeybaloney.hadeandepths.entity.ModEntities;
import com.kaironeybaloney.hadeandepths.item.custom.FishItem;
import com.kaironeybaloney.hadeandepths.item.custom.FishRarity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.ItemStackHandler;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ButcheringHookBlockEntity
extends BlockEntity
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Direction clickedFace = Direction.SOUTH;
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ButcheringHookBlockEntity.this.setChanged();
            if (ButcheringHookBlockEntity.this.level != null && !((ButcheringHookBlockEntity)ButcheringHookBlockEntity.this).level.isClientSide) {
                ButcheringHookBlockEntity.this.level.sendBlockUpdated(ButcheringHookBlockEntity.this.worldPosition, ButcheringHookBlockEntity.this.getBlockState(), ButcheringHookBlockEntity.this.getBlockState(), 3);
            }
        }
    };

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public ItemStack getItem() {
        return this.inventory.getStackInSlot(0);
    }

    public void setItem(ItemStack stack) {
        this.inventory.setStackInSlot(0, stack);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            if (!stack.isEmpty()) {
                this.spawnHangingFish(this.level, this.worldPosition);
            } else {
                this.removeHangingFish(this.level, this.worldPosition);
            }
        }
    }

    public ItemStack removeItem() {
        ItemStack current = this.inventory.getStackInSlot(0);
        if (current.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = current.copy();
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.removeHangingFish(this.level, this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        return ret;
    }

    public ButcheringHookBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BUTCHERING_HOOK_BLOCK_ENTITY.get(), pos, state);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void setClickedFace(Direction face) {
        this.clickedFace = face;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        System.out.println("SERVER: " + String.valueOf(face));
        System.out.println("CLIENT: " + String.valueOf(this.clickedFace));
    }

    public Direction getClickedFace() {
        return this.clickedFace;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Inventory")) {
            this.inventory.deserializeNBT(provider, tag.getCompound("Inventory"));
        }
        if (tag.contains("ClickedFace")) {
            this.clickedFace = Direction.values()[tag.getInt("ClickedFace")];
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
        if (this.clickedFace != null) {
            tag.putInt("ClickedFace", this.clickedFace.ordinal());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("Inventory")) {
            this.inventory.deserializeNBT(provider, tag.getCompound("Inventory"));
        }
        if (tag.contains("ClickedFace")) {
            this.inventory.deserializeNBT(provider, tag.getCompound("Inventory"));
        }
    }

    public void spawnHangingFish(Level level, BlockPos pos) {
        boolean isLegendary;
        boolean exists;
        if (level.isClientSide()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        boolean bl = exists = !level.getEntitiesOfClass(HangingFishEntity.class, new AABB(pos)).isEmpty();
        if (exists) {
            return;
        }
        FishRarity rarity = FishRarity.COMMON;
        Item item = stack.getItem();
        if (item instanceof FishItem) {
            FishItem fishItem = (FishItem)item;
            rarity = fishItem.getRarity(stack);
        }
        boolean bl2 = isLegendary = rarity == FishRarity.LEGENDARY;
        if (isLegendary) {
            entity = new HangingFishEntity(ModEntities.HANGING_FISH_LEGENDARY.get(), level);
            entity.setHook(pos);
            entity.setFishStack(this.getItem());
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() - 1.25, (double)pos.getZ() + 0.5);
            level.addFreshEntity((Entity)entity);
        } else {
            entity = new HangingFishEntity(ModEntities.HANGING_FISH_COMMON.get(), level);
            entity.setHook(pos);
            entity.setFishStack(this.getItem());
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() + 0.5);
            level.addFreshEntity((Entity)entity);
        }
    }

    public void removeHangingFish(Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        level.getEntitiesOfClass(HangingFishEntity.class, new AABB(pos)).forEach(Entity::discard);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return 0.0;
    }
}

