/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.block.entity;

import com.kaironeybaloney.hadeandepths.block.custom.DavyJonesLockerBlock;
import com.kaironeybaloney.hadeandepths.block.entity.ModBlockEntities;
import com.kaironeybaloney.hadeandepths.screen.custom.DavyJonesLockerMenu;
import com.kaironeybaloney.hadeandepths.sounds.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DavyJonesLockerBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider,
GeoBlockEntity {
    private NonNullList<ItemStack> items;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float openness;
    private float oOpenness;
    private final ContainerOpenersCounter openersCounter;

    public boolean isOpening() {
        return this.openersCounter.getOpenerCount() > 0;
    }

    public DavyJonesLockerBlockEntity(final BlockPos pos, final BlockState state) {
        super(ModBlockEntities.DAVY_JONES_LOCKER_BLOCK_ENTITY.get(), pos, state);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
                if (!level.isClientSide) {
                    return;
                }
                Direction facing = (Direction)state.getValue(DavyJonesLockerBlock.FACING);
                for (int i = 0; i < 10; ++i) {
                    double speed = 0.2 + level.random.nextDouble() * 0.05;
                    double spread = 0.3;
                    double dx = (double)facing.getStepX() * speed + (level.random.nextDouble() - 0.5) * spread;
                    double dy = 0.05 + (level.random.nextDouble() - 0.5) * 0.05;
                    double dz = (double)facing.getStepZ() * speed + (level.random.nextDouble() - 0.5) * spread;
                    double x = (double)pos.getX() + 0.6 + (double)facing.getStepX() * 0.6;
                    double y = (double)pos.getY() + 0.6;
                    double z = (double)pos.getZ() + 0.6 + (double)facing.getStepZ() * 0.6;
                    level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, dx, dy, dz);
                }
            }

            protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
            }

            protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int oldCount, int newCount) {
            }

            protected boolean isOwnContainer(Player player) {
                if (!(player.containerMenu instanceof DavyJonesLockerMenu)) {
                    return false;
                }
                Container container = ((DavyJonesLockerMenu)player.containerMenu).getContainer();
                return container == DavyJonesLockerBlockEntity.this;
            }
        };
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DavyJonesLockerBlockEntity be) {
        be.oOpenness = be.openness;
        be.openersCounter.recheckOpeners(level, pos, state);
        int openCount = be.openersCounter.getOpenerCount();
        if (openCount > 0 && be.openness == 0.0f) {
            level.playSound(null, pos, (SoundEvent)ModSounds.DAVY_JONES_LOCKER_OPEN.value(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        }
        if (openCount == 0 && be.openness > 0.0f || openCount > 0 && be.openness < 1.0f) {
            float prev = be.openness;
            be.openness = openCount > 0 ? (be.openness += 0.1f) : (be.openness -= 0.1f);
            be.openness = Mth.clamp((float)be.openness, (float)0.0f, (float)1.0f);
            if (be.openness < 0.5f && prev >= 0.5f) {
                level.playSound(null, pos, (SoundEvent)ModSounds.DAVY_JONES_LOCKER_CLOSE.value(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public float getOpenness(float partialTicks) {
        float linear = Mth.lerp((float)partialTicks, (float)this.oOpenness, (float)this.openness);
        return 1.0f - (float)Math.pow(1.0f - linear, 3.0);
    }

    public static int getOpenCount(BlockGetter level, BlockPos pos) {
        BlockEntity blockentity;
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.hasBlockEntity() && (blockentity = level.getBlockEntity(pos)) instanceof DavyJonesLockerBlockEntity) {
            return ((DavyJonesLockerBlockEntity)blockentity).openersCounter.getOpenerCount();
        }
        return 0;
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"Davy_Jones_Locker");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        }
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inv) {
        return new DavyJonesLockerMenu(id, inv, this);
    }

    public int getContainerSize() {
        return 36;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

