/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.client.renderer.block;

import com.kaironeybaloney.hadeandepths.block.entity.ButcheringHookBlockEntity;
import com.kaironeybaloney.hadeandepths.client.model.ButcheringHookModel;
import com.kaironeybaloney.hadeandepths.item.custom.FishItem;
import com.kaironeybaloney.hadeandepths.item.custom.FishRarity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class ButcheringHookRenderer
extends GeoBlockRenderer<ButcheringHookBlockEntity> {
    public ButcheringHookRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new ButcheringHookModel());
    }

    public AABB getRenderBoundingBox(ButcheringHookBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY() - 1.5, (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
    }

    public void render(ButcheringHookBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getItem();
        if (stack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        Direction clickedFace = blockEntity.getClickedFace();
        float yRot = switch (clickedFace) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
        FishRarity rarity = FishRarity.COMMON;
        Item fish = stack.getItem();
        if (fish instanceof FishItem) {
            float rot;
            FishItem fishItem = (FishItem)fish;
            rarity = fishItem.getRarity(stack);
            boolean isLegendary = rarity == FishRarity.LEGENDARY;
            switch (((FishItem)fish).getAttachPoint(stack)) {
                case BOTTOM_LEFT: {
                    float f = 135.0f;
                    break;
                }
                case BOTTOM_RIGHT: {
                    float f = -135.0f;
                    break;
                }
                case TOP_LEFT: {
                    float f = 45.0f;
                    break;
                }
                case TOP_RIGHT: {
                    float f = -45.0f;
                    break;
                }
                case TOP_MIDDLE: {
                    float f = 0.0f;
                    break;
                }
                default: {
                    float f = rot = 135.0f;
                }
            }
            if (isLegendary) {
                poseStack.pushPose();
                poseStack.translate(0.0, -1.125, -0.15625);
                poseStack.mulPose(Axis.ZP.rotationDegrees(rot));
                poseStack.scale(0.8f, 0.8f, 0.8f);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
                poseStack.popPose();
            } else {
                poseStack.translate(0.0, -0.6875, -0.15625);
                poseStack.mulPose(Axis.ZP.rotationDegrees(rot));
                poseStack.scale(0.7f, 0.7f, 0.7f);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            }
            poseStack.popPose();
        } else {
            poseStack.translate(0.0, -0.6875, -0.15625);
            poseStack.mulPose(Axis.ZP.rotationDegrees(135.0f));
            poseStack.scale(0.7f, 0.7f, 0.7f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

