/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.client.renderer.block;

import com.kaironeybaloney.hadeandepths.item.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GreenNiteliteJarRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;

    public GreenNiteliteJarRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderer = ctx.getBlockRenderDispatcher();
    }

    public void render(T be, float pt, PoseStack ps, MultiBufferSource buffers, int light, int overlay) {
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        if (level != null && level.isClientSide()) {
            if (Minecraft.getInstance().isPaused()) {
                return;
            }
            int divisor = 8;
            RandomSource rand = level.getRandom();
            for (int i = 0; i < 1 && rand.nextInt(divisor) == 0; ++i) {
                double x = (double)pos.getX() + Math.clamp(rand.nextDouble(), 0.25, 0.75);
                double y = (double)pos.getY() + Math.clamp(rand.nextDouble(), 0.0625, 0.625);
                double z = (double)pos.getZ() + Math.clamp(rand.nextDouble(), 0.25, 0.75);
                DustParticleOptions dust = new DustParticleOptions(10091442, 0.5f);
                level.addParticle((ParticleOptions)dust, x, y, z, 0.0, 10.0, 0.0);
            }
        }
        ps.pushPose();
        float time = (float)(be.getLevel() != null ? be.getLevel().getGameTime() : 0L) + pt + 15.0f;
        float bob = Mth.sin((float)(time * 0.05f)) * 0.05f;
        float weave = Mth.sin((float)(time * 0.05f)) * 0.025f;
        float weave2 = Mth.sin((float)(time * 0.075f)) * 0.025f;
        ps.translate(0.5 + (double)weave, (double)bob + 0.5, 0.5 + (double)weave2);
        ps.scale(1.0f, 1.0f, 1.0f);
        ps.mulPose(Axis.YP.rotationDegrees(time % 360.0f));
        VertexConsumer vc = buffers.getBuffer(Sheets.cutoutBlockSheet());
        ItemStack stack = new ItemStack((ItemLike)ModItems.GREEN_NITELITE_JELLYFISH.get());
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ps, buffers, be.getLevel(), be.getBlockPos().getY());
        ps.popPose();
    }
}

