/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.data.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record LoadedAmmoComponent(List<ItemStack> ammo, Set<Integer> usedSlots) implements DataComponentType
{
    public static final Codec<LoadedAmmoComponent> CODEC = ItemStack.CODEC.listOf().xmap(LoadedAmmoComponent::new, LoadedAmmoComponent::ammo);
    public static final StreamCodec<RegistryFriendlyByteBuf, LoadedAmmoComponent> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(LoadedAmmoComponent::new, LoadedAmmoComponent::ammo);

    public LoadedAmmoComponent(List<ItemStack> ammo) {
        this(ammo, new HashSet<Integer>());
    }

    public boolean isSlotUsed(int slot) {
        return this.usedSlots.contains(slot);
    }

    public LoadedAmmoComponent markSlotUsed(int slot) {
        HashSet<Integer> newSet = new HashSet<Integer>(this.usedSlots);
        newSet.add(slot);
        return new LoadedAmmoComponent(new ArrayList<ItemStack>(this.ammo), newSet);
    }

    @Nullable
    public Codec codec() {
        return CODEC;
    }

    public StreamCodec streamCodec() {
        return STREAM_CODEC;
    }
}

