/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.datagen.advancements;

import com.kaironeybaloney.hadeandepths.block.ModBlocks;
import com.kaironeybaloney.hadeandepths.item.ModItems;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModAdvancementGenerator
implements AdvancementSubProvider {
    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer) {
        this.createCollectAllFishAdvancement(consumer);
        this.createCollectAllOceanicFishAdvancement(consumer);
        this.createCollectAllAbyssalFishAdvancement(consumer);
        this.createCollectAllInlandFishAdvancement(consumer);
        this.createCollectAllAncientFishAdvancement(consumer);
        this.createCollectAllFabledFishAdvancement(consumer);
        this.createCollectAllCavernousFishAdvancement(consumer);
        this.createFindDavyJonesLockerAdvancement(consumer);
        this.createNiteliteJarAdvancement(consumer);
        this.createButcheringHookAdvancement(consumer);
        this.createToothArrowAdvancement(consumer);
        this.createCollectFirstLegendaryFishAdvancement(consumer);
        this.createCollectAllGlacialFishAdvancement(consumer);
        this.createDeepSeaResidueAdvancement(consumer);
        this.createCollectAllTidalArmorAdvancement(consumer);
        this.createTidalSledgeAdvancement(consumer);
        this.createTidalMorningStarAdvancement(consumer);
        this.createTidalBowAdvancement(consumer);
    }

    void createCollectAllGlacialFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> GLACIAL_FISH_ITEMS = List.of(ModItems.ICY_KRILL, ModItems.ICICLE_FISH, ModItems.FROZEN_FISH, ModItems.ORCA, ModItems.BLUE_NITELITE);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.FROZEN_FISH, (Component)Component.literal((String)"Ice Fishing"), (Component)Component.literal((String)"Collect every Glacial Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : GLACIAL_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_glacial_fish");
    }

    void createCollectFirstLegendaryFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<Supplier> LEGENDARY_FISH_ITEMS = List.of(ModItems.DUNKLEOSTEUS, ModItems.SEA_SERPENT, ModItems.GIANT_CATFISH, ModItems.GREAT_WHITE_SHARK, ModItems.COLOSSAL_SQUID, ModItems.STURGEON, ModItems.AMETHYST_GROUPER, ModItems.TUNA, ModItems.FRILLED_SHARK, ModItems.PHANTOM_JELLYFISH, ModItems.MEGALODON);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.GREAT_WHITE_SHARK, (Component)Component.literal((String)"Legendary Fisherman"), (Component)Component.literal((String)"Collect your first Legendary Fish"), null, AdvancementType.TASK, true, true, false);
        for (Supplier fishSupplier : LEGENDARY_FISH_ITEMS) {
            Item fishItem = (Item)fishSupplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.requirements(AdvancementRequirements.Strategy.OR);
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_first_legendary_fish");
    }

    void createNiteliteJarAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModBlocks.BLUE_NITELITE_JAR, (Component)Component.literal((String)"Jellyfish Museum"), (Component)Component.literal((String)"Craft a Nitelite in a jar"), null, AdvancementType.TASK, true, true, false);
        builder.addCriterion("has_blue_nitelite", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModBlocks.BLUE_NITELITE_JAR}));
        builder.addCriterion("has_green_nitelite", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModBlocks.GREEN_NITELITE_JAR}));
        builder.addCriterion("has_pink_nitelite", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModBlocks.PINK_NITELITE_JAR}));
        builder.requirements(AdvancementRequirements.Strategy.OR);
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/root"));
        builder.save(consumer, "hadeandepths:craft_nitelite_in_a_jar");
    }

    void createButcheringHookAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModBlocks.BUTCHERING_HOOK, (Component)Component.literal((String)"Hooked"), (Component)Component.literal((String)"Craft a Butchering Hook"), null, AdvancementType.TASK, true, true, false);
        builder.addCriterion("has_butchering_hook", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModBlocks.BUTCHERING_HOOK}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/root"));
        builder.save(consumer, "hadeandepths:craft_butchering_hook");
    }

    void createDeepSeaResidueAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.DEEP_SEA_RESIDUE, (Component)Component.literal((String)"Abyssal Remnants"), (Component)Component.literal((String)"Find a Deep Sea Residue"), null, AdvancementType.TASK, true, true, false);
        builder.addCriterion("has_deep_sea_residue", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.DEEP_SEA_RESIDUE}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/root"));
        builder.save(consumer, "hadeandepths:find_deep_sea_residue");
    }

    void createTidalBowAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.SERPENT_BONE_BOW, (Component)Component.literal((String)"The Eb and Flow of the Tides"), (Component)Component.literal((String)"Craft a Tidal Bow"), null, AdvancementType.GOAL, true, true, false);
        builder.addCriterion("has_tidal_bow", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.SERPENT_BONE_BOW}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"find_deep_sea_residue"));
        builder.save(consumer, "hadeandepths:craft_tidal_bow");
    }

    void createTidalMorningStarAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.TIDAL_MORNING_STAR, (Component)Component.literal((String)"Sea Urchin on a Stick"), (Component)Component.literal((String)"Craft a Tidal Morning Star"), null, AdvancementType.GOAL, true, true, false);
        builder.addCriterion("has_tidal_morning_star", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.TIDAL_MORNING_STAR}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"find_deep_sea_residue"));
        builder.save(consumer, "hadeandepths:craft_tidal_morning_star");
    }

    void createTidalSledgeAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.TIDAL_SLEDGE, (Component)Component.literal((String)"With All the Force of A Great Typhoon"), (Component)Component.literal((String)"Craft a Tidal Sledge"), null, AdvancementType.GOAL, true, true, false);
        builder.addCriterion("has_tidal_sledge", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.TIDAL_SLEDGE}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"find_deep_sea_residue"));
        builder.save(consumer, "hadeandepths:craft_tidal_sledge");
    }

    void createCollectAllTidalArmorAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> CAVERNOUS_FISH_ITEMS = List.of(ModItems.TIDAL_HELMET, ModItems.TIDAL_CHESTPLATE, ModItems.TIDAL_LEGGINGS, ModItems.TIDAL_BOOTS);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.TIDAL_CHESTPLATE, (Component)Component.literal((String)"Cover Me in the Sea"), (Component)Component.literal((String)"Collect every Tidal Armor Piece"), null, AdvancementType.CHALLENGE, true, true, false);
        for (Supplier supplier : CAVERNOUS_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"find_deep_sea_residue"));
        builder.save(consumer, "hadeandepths:collect_all_tidal_armor");
    }

    void createToothArrowAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModBlocks.BUTCHERING_HOOK, (Component)Component.literal((String)"Sharper Arrows"), (Component)Component.literal((String)"Craft a Tooth Arrow that works above and below"), null, AdvancementType.TASK, true, true, false);
        builder.addCriterion("has_tooth_arrow", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.TOOTH_ARROW}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/craft_butchering_hook"));
        builder.save(consumer, "hadeandepths:craft_tooth_arrow");
    }

    void createFindDavyJonesLockerAdvancement(Consumer<AdvancementHolder> consumer) {
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModBlocks.DAVY_JONES_LOCKER, (Component)Component.literal((String)"Dead Men Tell No Tales"), (Component)Component.literal((String)"Fish up Davy Jones' Locker"), null, AdvancementType.GOAL, true, true, false);
        builder.addCriterion("has_davy_jones_locker", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModBlocks.DAVY_JONES_LOCKER}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/root"));
        builder.save(consumer, "hadeandepths:find_davy_jones_locker");
    }

    void createCollectAllCavernousFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> CAVERNOUS_FISH_ITEMS = List.of(ModItems.GOLD_FISH, ModItems.GLOW_FISH, ModItems.GHOST_FISH, ModItems.CAVE_CARP, ModItems.AMETHYST_GROUPER);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.GOLD_FISH, (Component)Component.literal((String)"Fishy Subterranean Wonders"), (Component)Component.literal((String)"Collect every Cavernous Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : CAVERNOUS_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_cavernous_fish");
    }

    void createCollectAllFabledFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> FABLED_FISH_ITEMS = List.of(ModItems.MINN_O_WISP, ModItems.FISH, ModItems.SEA_SERPENT, ModItems.FUR_BEARING_TROUT, ModItems.BASSIGATOR, ModItems.RED_HERRING);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.MINN_O_WISP, (Component)Component.literal((String)"The Things of Legend"), (Component)Component.literal((String)"Collect every Fabled Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : FABLED_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_fabled_fish");
    }

    void createCollectAllAncientFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> ANCIENT_FISH_ITEMS = List.of(ModItems.TRILOBITE, ModItems.NAUTILUS, ModItems.HORSESHOE_CRAB, ModItems.DUNKLEOSTEUS, ModItems.COELACANTH, ModItems.MEGALODON);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.COELACANTH, (Component)Component.literal((String)"The Living Fossils"), (Component)Component.literal((String)"Collect every Ancient Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : ANCIENT_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_ancient_fish");
    }

    void createCollectAllInlandFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> INLAND_FISH_ITEMS = List.of(ModItems.ZOMBIE_FISH, ModItems.CARP, ModItems.GIANT_CATFISH, ModItems.STURGEON, ModItems.TIGER_FISH, ModItems.TROUT);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.CARP, (Component)Component.literal((String)"Ain't no River Wide Enough"), (Component)Component.literal((String)"Collect every Inland Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : INLAND_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.addCriterion("has_salmon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SALMON}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_inland_fish");
    }

    void createCollectAllAbyssalFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> ABYSSAL_FISH_ITEMS = List.of(ModItems.LAMPLIGHTER, ModItems.COLOSSAL_SQUID, ModItems.BLOBFISH, ModItems.LANTERN_FISH, ModItems.FRILLED_SHARK, ModItems.SLACK_JAW, ModItems.PHANTOM_JELLYFISH);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.SLACK_JAW, (Component)Component.literal((String)"Cast Into the Abyss"), (Component)Component.literal((String)"Collect every Abyssal Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : ABYSSAL_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_abyssal_fish");
    }

    void createCollectAllOceanicFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<DeferredItem<Item>> OCEANIC_FISH_ITEMS = List.of(ModItems.REAPER_FIN, ModItems.EEL, ModItems.PINK_NITELITE, ModItems.GREEN_NITELITE, ModItems.ELECTRIC_EEL, ModItems.GREAT_WHITE_SHARK, ModItems.TUNA, ModItems.BARRACUDA);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.EEL, (Component)Component.literal((String)"The Great Blue Sea"), (Component)Component.literal((String)"Collect every Oceanic Fish"), null, AdvancementType.GOAL, true, true, false);
        for (Supplier supplier : OCEANIC_FISH_ITEMS) {
            Item fishItem = (Item)supplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.addCriterion("has_cod", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COD}));
        builder.addCriterion("has_tropical_fish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH}));
        builder.addCriterion("has_pufferfish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PUFFERFISH}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fishing/first_fish"));
        builder.save(consumer, "hadeandepths:collect_all_oceanic_fish");
    }

    void createCollectAllFishAdvancement(Consumer<AdvancementHolder> consumer) {
        List<Supplier> ALL_FISH_ITEMS = List.of(ModItems.REAPER_FIN, ModItems.EEL, ModItems.LAMPLIGHTER, ModItems.GOLD_FISH, ModItems.COELACANTH, ModItems.FISH, ModItems.CARP, ModItems.TRILOBITE, ModItems.GREEN_NITELITE, ModItems.BLUE_NITELITE, ModItems.PINK_NITELITE, ModItems.AMETHYST_GROUPER, ModItems.BARRACUDA, ModItems.BLOBFISH, ModItems.CAVE_CARP, ModItems.COLOSSAL_SQUID, ModItems.DUNKLEOSTEUS, ModItems.ELECTRIC_EEL, ModItems.LANTERN_FISH, ModItems.TUNA, ModItems.ZOMBIE_FISH, ModItems.GIANT_CATFISH, ModItems.GREAT_WHITE_SHARK, ModItems.GLOW_FISH, ModItems.GHOST_FISH, ModItems.HORSESHOE_CRAB, ModItems.NAUTILUS, ModItems.MINN_O_WISP, ModItems.SEA_SERPENT, ModItems.STURGEON, ModItems.TIGER_FISH, ModItems.FRILLED_SHARK, ModItems.ICY_KRILL, ModItems.TROUT, ModItems.FUR_BEARING_TROUT, ModItems.ICICLE_FISH, ModItems.FROZEN_FISH, ModItems.ORCA, ModItems.BASSIGATOR, ModItems.SLACK_JAW, ModItems.PHANTOM_JELLYFISH, ModItems.MEGALODON, ModItems.RED_HERRING);
        Advancement.Builder builder = Advancement.Builder.advancement().display(ModItems.FISH, (Component)Component.literal((String)"Master Baiter"), (Component)Component.literal((String)"Collect every Fish"), null, AdvancementType.CHALLENGE, true, true, false);
        for (Supplier fishSupplier : ALL_FISH_ITEMS) {
            Item fishItem = (Item)fishSupplier.get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)fishItem);
            builder.addCriterion("has_" + itemId.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fishItem}));
        }
        builder.addCriterion("has_cod", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COD}));
        builder.addCriterion("has_tropical_fish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH}));
        builder.addCriterion("has_pufferfish", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PUFFERFISH}));
        InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SALMON});
        builder.addCriterion("has_salmon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SALMON}));
        builder.parent(ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"collect_first_legendary_fish"));
        builder.save(consumer, "hadeandepths:collect_all_fish");
    }
}

