/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.entity;

import com.kaironeybaloney.hadeandepths.block.entity.ButcheringHookBlockEntity;
import com.kaironeybaloney.hadeandepths.item.custom.FishItem;
import com.kaironeybaloney.hadeandepths.item.custom.FishRarity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class HangingFishEntity
extends Entity {
    private BlockPos hookPos;
    private ItemStack fishStack = ItemStack.EMPTY;
    private Level level;

    public HangingFishEntity(EntityType<? extends HangingFishEntity> type, Level level2) {
        super(type, level2);
        this.noPhysics = true;
        this.level = level2;
    }

    public void setHook(BlockPos pos) {
        this.hookPos = pos;
    }

    public BlockPos getHookPos() {
        return this.hookPos;
    }

    public Level getLevel() {
        return this.level;
    }

    public ButcheringHookBlockEntity getHookBlockEntity() {
        if (this.hookPos == null) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(this.hookPos);
        if (be instanceof ButcheringHookBlockEntity) {
            ButcheringHookBlockEntity hook = (ButcheringHookBlockEntity)be;
            return hook;
        }
        return null;
    }

    public void setFishStack(ItemStack stack) {
        this.fishStack = stack;
    }

    public ItemStack getFishStack() {
        return this.fishStack;
    }

    public boolean isPickable() {
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        TagKey FISH_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"fish"));
        TagKey BUTCHERING_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)"butchering_item"));
        if (!this.level.isClientSide) {
            System.out.println("INTERACTED WITH FISH");
            ButcheringHookBlockEntity hook = this.getHookBlockEntity();
            if (hook == null) {
                return InteractionResult.PASS;
            }
            ItemStack held = player.getItemInHand(hand);
            if (held.is(BUTCHERING_TAG) && !hook.isEmpty()) {
                this.level.playSound(null, this.hookPos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f);
                this.dropFishLoot(this.level, this.hookPos, hook.getItem());
                ItemStack removed = hook.removeItem();
                hook.setChanged();
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                return InteractionResult.SUCCESS;
            }
            if (held.isEmpty()) {
                this.level.playSound(null, this.hookPos, SoundEvents.SALMON_FLOP, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f);
                ItemStack removed = hook.removeItem();
                if (!removed.isEmpty() && !player.getInventory().add(removed.copy())) {
                    player.drop(removed.copy(), false);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            } else if (held.is(FISH_TAG)) {
                this.level.playSound(null, this.hookPos, SoundEvents.SALMON_FLOP, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f);
                if (hook.isEmpty()) {
                    ItemStack toInsert = held.copy();
                    toInsert.setCount(1);
                    hook.setItem(toInsert);
                    if (!player.isCreative()) {
                        held.shrink(1);
                    }
                    hook.setChanged();
                    return InteractionResult.SUCCESS;
                }
                ItemStack removed = hook.removeItem();
                if (!removed.isEmpty()) {
                    if (!player.getInventory().add(removed.copy())) {
                        player.drop(removed.copy(), false);
                    }
                    hook.setChanged();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    private void dropFishLoot(Level level, BlockPos pos, ItemStack fish) {
        if (fish.isEmpty() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FishRarity rarity = FishRarity.COMMON;
        Item item = fish.getItem();
        if (item instanceof FishItem) {
            FishItem fishItem = (FishItem)item;
            rarity = fishItem.getRarity(fish);
        }
        boolean isLegendary = rarity == FishRarity.LEGENDARY;
        ResourceLocation fishID = BuiltInRegistries.ITEM.getKey((Object)fish.getItem());
        ResourceLocation lootTableID = ResourceLocation.fromNamespaceAndPath((String)"hadeandepths", (String)("butchering/" + fishID.getPath()));
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableID);
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableKey);
        LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK);
        ObjectArrayList drops = lootTable.getRandomItems(params);
        for (ItemStack stack : drops) {
            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)(isLegendary ? (double)pos.getY() - 1.0 : (double)pos.getY() - 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)stack);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float v) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }
}

