/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.item.custom;

import com.kaironeybaloney.hadeandepths.item.custom.FishAttachPoint;
import com.kaironeybaloney.hadeandepths.item.custom.FishRarity;
import com.kaironeybaloney.hadeandepths.item.custom.FishType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class FishItem
extends Item {
    private final FishRarity rarity;
    private final FishType type;
    private final FishAttachPoint attachPoint;

    public FishItem(Item.Properties properties, FishRarity itemRarity, FishType fishType) {
        super(properties);
        this.rarity = itemRarity;
        this.type = fishType;
        this.attachPoint = FishAttachPoint.BOTTOM_LEFT;
    }

    public FishItem(Item.Properties properties, FishRarity itemRarity, FishType fishType, FishAttachPoint fishAttachPoint) {
        super(properties);
        this.rarity = itemRarity;
        this.type = fishType;
        this.attachPoint = fishAttachPoint;
    }

    public FishRarity getRarity(ItemStack stack) {
        return this.rarity;
    }

    public FishType getType(ItemStack stack) {
        return this.type;
    }

    public FishAttachPoint getAttachPoint(ItemStack stack) {
        return this.attachPoint;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flags) {
        if (Screen.hasShiftDown()) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this);
            if (id != null) {
                MutableComponent rarityComp = Component.translatable((String)("rarity." + this.rarity.getSerializedName()));
                MutableComponent typeComp = Component.translatable((String)("type." + this.type.getSerializedName()));
                MutableComponent combined = Component.translatable((String)"tooltip.hadeandepths.rarity_type", (Object[])new Object[]{rarityComp, typeComp});
                tooltipComponents.add((Component)combined);
                tooltipComponents.add((Component)Component.translatable((String)("tooltip." + id.getNamespace() + "." + id.getPath())).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hadeandepths.shift_up"));
        }
        super.appendHoverText(stack, context, tooltipComponents, flags);
    }
}

