/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.item.custom;

import com.kaironeybaloney.hadeandepths.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class GlassJarItem
extends Item {
    public GlassJarItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        BlockHitResult hitResult = GlassJarItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            int currentLevel;
            BlockPos pos = hitResult.getBlockPos();
            if (!world.mayInteract(player, pos)) {
                return InteractionResult.PASS;
            }
            BlockState state = world.getBlockState(pos);
            if (state.is(Blocks.WATER_CAULDRON) && (currentLevel = ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) > 0) {
                if (!world.isClientSide) {
                    if (currentLevel > 1) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(currentLevel - 1)), 3);
                    } else {
                        world.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 3);
                    }
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                    world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
                }
                this.swapItem(player, stackInHand);
                return InteractionResult.SUCCESS.heldItemTransformedTo(stackInHand);
            }
            FluidState fluidState = world.getFluidState(pos);
            if (fluidState.is(FluidTags.WATER) && fluidState.isSource()) {
                if (!world.isClientSide) {
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                    world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
                }
                this.swapItem(player, stackInHand);
                return InteractionResult.SUCCESS.heldItemTransformedTo(stackInHand);
            }
        }
        return InteractionResult.PASS;
    }

    private void swapItem(Player player, ItemStack original) {
        if (!player.getAbilities().instabuild) {
            original.shrink(1);
        }
        ItemStack result = new ItemStack((ItemLike)ModItems.WATER_JAR.get());
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getInventory().add(result)) {
            player.drop(result, false);
        }
    }
}

