/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;

public class NetheriteRodItem
extends FishingRodItem {
    public NetheriteRodItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                int i = player.fishing.retrieve(itemstack);
                ItemStack original = itemstack.copy();
                itemstack.hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                if (itemstack.isEmpty()) {
                    EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)original, (InteractionHand)hand);
                }
            }
            level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                int j = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverlevel, (ItemStack)itemstack, (Entity)player) * 20.0f * 1.5f);
                int k = (int)((float)EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverlevel, (ItemStack)itemstack, (Entity)player) * 1.5f);
                Projectile.spawnProjectile((Projectile)new FishingHook(player, level, k, j), (ServerLevel)serverlevel, (ItemStack)itemstack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this);
            if (id != null) {
                tooltipComponents.add((Component)Component.translatable((String)("tooltip." + id.getNamespace() + "." + id.getPath() + "_lure")).withStyle(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.translatable((String)("tooltip." + id.getNamespace() + "." + id.getPath() + "_luck")).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hadeandepths.shift_up"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

