/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.item.custom;

import com.kaironeybaloney.hadeandepths.data.ModDataComponents;
import com.kaironeybaloney.hadeandepths.data.custom.LoadedAmmoComponent;
import com.kaironeybaloney.hadeandepths.event.TickScheduler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class SerpentBoneBowItem
extends BowItem {
    public SerpentBoneBowItem(Item.Properties properties) {
        super(properties);
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks) {
        if (!(user instanceof Player)) {
            return false;
        }
        Player player = (Player)user;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LoadedAmmoComponent comp = (LoadedAmmoComponent)stack.get(ModDataComponents.LOADED_AMMO);
        if (comp == null || comp.ammo().isEmpty()) {
            return false;
        }
        float charge = SerpentBoneBowItem.getPowerForTime(this.getUseDuration(stack, (LivingEntity)player) - remainingUseTicks);
        if (charge < 0.1f) {
            return false;
        }
        List<ItemStack> arrowsToFire = comp.ammo();
        stack.remove(ModDataComponents.LOADED_AMMO);
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!arrowsToFire.isEmpty()) {
                this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, arrowsToFire, charge * 3.0f, 1.0f, charge == 1.0f, null);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return true;
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            int index = i;
            int delay = 11 * index;
            TickScheduler.schedule(level, delay, () -> {
                Projectile.spawnProjectile((Projectile)this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit), (ServerLevel)level, (ItemStack)itemstack, p -> this.shootProjectile(shooter, (Projectile)p, index, velocity, inaccuracy, f4, target));
                level.playSound((Player)null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f4 * 0.5f);
                level.playSound((Player)null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.TRIDENT_RIPTIDE_1, SoundSource.PLAYERS, 0.25f * velocity, 1.5f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f4 * 0.5f);
                if (shooter instanceof Player) {
                    if (!((Player)shooter).isCreative()) {
                        weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                    ((Player)shooter).getInventory().items.stream().filter(s -> !s.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)((ItemStack)projectileItems.get(index)))).findFirst().ifPresent(s -> s.shrink(1));
                }
            });
        }
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 3.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        boolean flag = !player.getProjectile(stack = player.getItemInHand(hand)).isEmpty();
        InteractionResult ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.hasInfiniteMaterials() && !flag) {
            return InteractionResult.FAIL;
        }
        ArrayList<ItemStack> ammo = new ArrayList<ItemStack>();
        HashSet<Integer> used = new HashSet<Integer>();
        if (!level.isClientSide()) {
            for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                ItemStack invStack = player.getInventory().getItem(slot);
                if (!invStack.is(ItemTags.ARROWS)) continue;
                ammo.add(invStack.copyWithCount(1));
                if (invStack.getCount() < 2) {
                    used.add(slot);
                }
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_LOADING_START, SoundSource.PLAYERS, 1.5f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
                System.out.println("Added arrow on use(): " + String.valueOf(invStack));
                stack.set(ModDataComponents.LOADED_AMMO, (Object)new LoadedAmmoComponent(ammo, used));
                player.startUsingItem(hand);
                return InteractionResult.CONSUME;
            }
            if (player.isCreative()) {
                ItemStack arrowStack = Items.ARROW.getDefaultInstance();
                ammo.add(arrowStack.copyWithCount(1));
                stack.set(ModDataComponents.LOADED_AMMO, (Object)new LoadedAmmoComponent(ammo, used));
                player.startUsingItem(hand);
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_LOADING_START, SoundSource.PLAYERS, 1.5f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.FAIL;
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int count) {
        ItemStack inv;
        int slot;
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (level.isClientSide()) {
            return;
        }
        LoadedAmmoComponent comp = (LoadedAmmoComponent)stack.get(ModDataComponents.LOADED_AMMO);
        int useTime = this.getUseDuration(stack, user) - count;
        int ammoCount = comp.ammo().size();
        if (useTime >= 35 && ammoCount == 1) {
            ArrayList<ItemStack> ammo = new ArrayList<ItemStack>(comp.ammo());
            HashSet<Integer> used = new HashSet<Integer>(comp.usedSlots());
            boolean addedArrow = false;
            for (slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                if (used.contains(slot) || !(inv = player.getInventory().getItem(slot)).is(ItemTags.ARROWS)) continue;
                ammo.add(inv.copyWithCount(1));
                if (inv.getCount() < 3) {
                    used.add(slot);
                }
                addedArrow = true;
                stack.set(ModDataComponents.LOADED_AMMO, (Object)new LoadedAmmoComponent(ammo, used));
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_LOADING_END, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
                System.out.println("Added arrow #2 from slot " + slot);
                break;
            }
            if (!addedArrow && player.isCreative()) {
                ItemStack arrowStack = Items.ARROW.getDefaultInstance();
                ammo.add(arrowStack.copyWithCount(1));
                stack.set(ModDataComponents.LOADED_AMMO, (Object)new LoadedAmmoComponent(ammo, used));
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_LOADING_END, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
            }
        }
        if (useTime >= 50 && ammoCount == 2) {
            boolean addedArrow = false;
            ArrayList<ItemStack> ammo = new ArrayList<ItemStack>(comp.ammo());
            HashSet<Integer> used = new HashSet<Integer>(comp.usedSlots());
            for (slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                if (used.contains(slot) || !(inv = player.getInventory().getItem(slot)).is(ItemTags.ARROWS)) continue;
                ammo.add(inv.copyWithCount(1));
                stack.set(ModDataComponents.LOADED_AMMO, (Object)new LoadedAmmoComponent(ammo, used));
                addedArrow = true;
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_LOADING_END, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
                System.out.println("Added arrow #3 from slot " + slot);
                break;
            }
            if (!addedArrow && player.isCreative()) {
                ItemStack arrowStack = Items.ARROW.getDefaultInstance();
                ammo.add(arrowStack.copyWithCount(1));
                stack.set(ModDataComponents.LOADED_AMMO, (Object)new LoadedAmmoComponent(ammo, used));
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.CROSSBOW_LOADING_END, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
            }
        }
    }

    public int getUseDuration(ItemStack p_40680_, LivingEntity p_345962_) {
        return 72000;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flags) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.hadeandepths.tidal_bow"));
        super.appendHoverText(stack, context, tooltipComponents, flags);
    }
}

