/*
 * Decompiled with CFR 0.152.
 */
package com.kaironeybaloney.hadeandepths.item.custom;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;

public class TidalSledgeItem
extends SwordItem {
    public TidalSledgeItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean result = super.hurtEnemy(stack, target, attacker);
        if (!attacker.level().isClientSide()) {
            float strength = 1.0f;
            double x = -Math.sin((double)attacker.getYRot() * (Math.PI / 180)) * (double)strength;
            double z = Math.cos((double)attacker.getYRot() * (Math.PI / 180)) * (double)strength;
            target.push(x, (double)0.1f, z);
            target.hurtMarked = true;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            float charge = ((Player)attacker).getAttackStrengthScale(0.5f);
            if ((double)charge > 0.5 && !target.level().isClientSide()) {
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1, true, false));
            }
        }
        return result;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity victim, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flags) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.hadeandepths.tidal_sledge"));
        super.appendHoverText(stack, context, tooltipComponents, flags);
    }
}

